/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.contek.invoker.bybit.api.rest.market.MarketRestApi;
import io.contek.invoker.bybit.api.rest.user.UserRestApi;
import io.contek.invoker.bybit.api.websocket.market.MarketWebSocketApi;
import io.contek.invoker.bybit.api.websocket.user.UserWebSocketApi;
import io.contek.invoker.commons.api.ApiContext;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.IActorFactory;
import io.contek.invoker.commons.api.actor.SimpleActorFactory;
import io.contek.invoker.commons.api.actor.http.IHttpClientFactory;
import io.contek.invoker.commons.api.actor.http.IHttpContext;
import io.contek.invoker.commons.api.actor.http.SimpleHttpClientFactory;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitQuotaInterceptor;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottleFactory;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitCache;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitRule;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitType;
import io.contek.invoker.commons.api.actor.ratelimit.SimpleRateLimitThrottleFactory;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.websocket.WebSocketContext;
import io.contek.invoker.security.ApiKey;
import io.contek.invoker.security.ICredentialFactory;
import io.contek.invoker.security.SecretKeyAlgorithm;
import io.contek.invoker.security.SimpleCredentialFactory;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ApiFactory {
    public static final ApiContext MAIN_NET_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"https://api.bybit.com")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"wss://stream.bybit.com")).build();
    public static final ApiContext TEST_NET_CONTEXT = ApiContext.newBuilder().setRestContext(RestContext.forBaseUrl((String)"https://api-testnet.bybit.com")).setWebSocketContext(WebSocketContext.forBaseUrl((String)"wss://stream-testnet.bybit.com")).build();
    private final ApiContext context;
    private final IActorFactory actorFactory;

    private ApiFactory(ApiContext context, IActorFactory actorFactory) {
        this.context = context;
        this.actorFactory = actorFactory;
    }

    public static ApiFactory getMainNetDefault() {
        return ApiFactory.fromContext(MAIN_NET_CONTEXT);
    }

    public static ApiFactory getTestNetDefault() {
        return ApiFactory.fromContext(TEST_NET_CONTEXT);
    }

    public static ApiFactory fromContext(ApiContext context) {
        return new ApiFactory(context, (IActorFactory)ApiFactory.createActorFactory(context.getInterceptor()));
    }

    public SelectingRestApi rest() {
        return new SelectingRestApi();
    }

    public SelectingWebSocketApi ws() {
        return new SelectingWebSocketApi();
    }

    private static SimpleActorFactory createActorFactory(@Nullable IRateLimitQuotaInterceptor interceptor) {
        return SimpleActorFactory.newBuilder().setCredentialFactory((ICredentialFactory)ApiFactory.createCredentialFactory()).setHttpClientFactory((IHttpClientFactory)SimpleHttpClientFactory.getInstance()).setRateLimitThrottleFactory((IRateLimitThrottleFactory)SimpleRateLimitThrottleFactory.create((RateLimitCache)ApiFactory.createRateLimitCache(), (IRateLimitQuotaInterceptor)interceptor)).build();
    }

    private static SimpleCredentialFactory createCredentialFactory() {
        return SimpleCredentialFactory.newBuilder().setAlgorithm(SecretKeyAlgorithm.HMAC_SHA256).setEncoding(BaseEncoding.base16().upperCase()).build();
    }

    private static RateLimitCache createRateLimitCache() {
        return RateLimitCache.newBuilder().addRule(RateLimits.IP_REST_GET_REQUEST_RULE).addRule(RateLimits.IP_REST_POST_REQUEST_RULE).addRule(RateLimits.API_KEY_REST_ORDER_WRITE_RULE).addRule(RateLimits.API_KEY_REST_ORDER_READ_RULE).addRule(RateLimits.API_KEY_REST_TRADE_READ_RULE).addRule(RateLimits.API_KEY_REST_POSITION_WRITE_RULE).addRule(RateLimits.API_KEY_REST_POSITION_READ_RULE).addRule(RateLimits.API_KEY_REST_FUNDING_READ_RULE).addRule(RateLimits.API_KEY_REST_FUND_READ_RULE).addRule(RateLimits.API_KEY_REST_KEY_INFO_READ_RULE).build();
    }

    @ThreadSafe
    public final class SelectingRestApi {
        private SelectingRestApi() {
        }

        public MarketRestApi market() {
            RestContext restContext = ApiFactory.this.context.getRestContext();
            IActor actor = ApiFactory.this.actorFactory.create(null, (IHttpContext)restContext);
            return new MarketRestApi(actor, restContext);
        }

        public UserRestApi user(ApiKey apiKey) {
            RestContext restContext = ApiFactory.this.context.getRestContext();
            IActor actor = ApiFactory.this.actorFactory.create(apiKey, (IHttpContext)restContext);
            return new UserRestApi(actor, restContext);
        }
    }

    @ThreadSafe
    public final class SelectingWebSocketApi {
        private SelectingWebSocketApi() {
        }

        public MarketWebSocketApi market() {
            WebSocketContext wsContext = ApiFactory.this.context.getWebSocketContext();
            IActor actor = ApiFactory.this.actorFactory.create(null, (IHttpContext)wsContext);
            return new MarketWebSocketApi(actor, wsContext);
        }

        public UserWebSocketApi user(ApiKey apiKey) {
            WebSocketContext wsContext = ApiFactory.this.context.getWebSocketContext();
            IActor actor = ApiFactory.this.actorFactory.create(apiKey, (IHttpContext)wsContext);
            return new UserWebSocketApi(actor, wsContext);
        }
    }

    @Immutable
    public static final class RateLimits {
        public static final RateLimitRule IP_REST_GET_REQUEST_RULE = RateLimitRule.newBuilder().setName("ip_rest_get_request_rule").setType(RateLimitType.IP).setMaxPermits(50).setResetPeriod(Duration.ofSeconds(1L)).build();
        public static final RateLimitRule IP_REST_POST_REQUEST_RULE = RateLimitRule.newBuilder().setName("ip_rest_post_request_rule").setType(RateLimitType.IP).setMaxPermits(20).setResetPeriod(Duration.ofSeconds(1L)).build();
        public static final RateLimitRule API_KEY_REST_ORDER_WRITE_RULE = RateLimitRule.newBuilder().setName("api_key_rest_order_write_rule").setType(RateLimitType.API_KEY).setMaxPermits(100).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_ORDER_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_order_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(600).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_TRADE_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_trade_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(120).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_POSITION_WRITE_RULE = RateLimitRule.newBuilder().setName("api_key_rest_position_write_rule").setType(RateLimitType.API_KEY).setMaxPermits(75).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_POSITION_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_position_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(120).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_FUNDING_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_funding_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(120).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_FUND_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_wallet_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(120).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final RateLimitRule API_KEY_REST_KEY_INFO_READ_RULE = RateLimitRule.newBuilder().setName("api_key_rest_info_read_rule").setType(RateLimitType.API_KEY).setMaxPermits(600).setResetPeriod(Duration.ofMinutes(1L)).build();
        public static final ImmutableList<RateLimitQuota> ONE_REST_PUBLIC_GET_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_ORDER_WRITE_REQUEST = ImmutableList.of((Object)IP_REST_POST_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_ORDER_WRITE_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_ORDER_READ_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_ORDER_READ_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_TRADE_READ_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_TRADE_READ_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_POSITION_READ_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_POSITION_READ_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_POSITION_WRITE_REQUEST = ImmutableList.of((Object)IP_REST_POST_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_POSITION_WRITE_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_FUND_READ_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_FUND_READ_RULE.createRateLimitQuota(1));
        public static final ImmutableList<RateLimitQuota> ONE_REST_PRIVATE_KEY_INFO_READ_REQUEST = ImmutableList.of((Object)IP_REST_GET_REQUEST_RULE.createRateLimitQuota(1), (Object)API_KEY_REST_KEY_INFO_READ_RULE.createRateLimitQuota(1));

        private RateLimits() {
        }
    }
}

