/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);

    public static Clock getClock() {
        return Clock.systemUTC();
    }

    public static <RESULT> RESULT time(Callable<RESULT> func) {
        return TimeUtils.timeWithMeta(func).getResult();
    }

    public static <RESULT> TimeResult<RESULT> timeWithMeta(Callable<? extends RESULT> func) {
        long start = System.currentTimeMillis();
        TimeResult.TimeResultBuilder<RESULT> timer = TimeResult.builder().startMs(start);
        RESULT call = func.call();
        timer.result(call);
        long end = System.currentTimeMillis();
        long elapsed = end - start;
        timer.endMs(end);
        log.trace("Function took {}", (Object)Duration.ofMillis(elapsed));
        return timer.build();
    }

    private TimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class TimeResult<RESULT> {
        private final long startMs;
        private final long endMs;
        private final RESULT result;

        public Duration getElapsed() {
            return Duration.ofMillis(this.endMs - this.startMs);
        }

        TimeResult(long startMs, long endMs, RESULT result) {
            this.startMs = startMs;
            this.endMs = endMs;
            this.result = result;
        }

        public static <RESULT> TimeResultBuilder<RESULT> builder() {
            return new TimeResultBuilder();
        }

        public long getStartMs() {
            return this.startMs;
        }

        public long getEndMs() {
            return this.endMs;
        }

        public RESULT getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeResult)) {
                return false;
            }
            TimeResult other = (TimeResult)o;
            if (this.getStartMs() != other.getStartMs()) {
                return false;
            }
            if (this.getEndMs() != other.getEndMs()) {
                return false;
            }
            RESULT this$result = this.getResult();
            RESULT other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startMs = this.getStartMs();
            result = result * 59 + (int)($startMs >>> 32 ^ $startMs);
            long $endMs = this.getEndMs();
            result = result * 59 + (int)($endMs >>> 32 ^ $endMs);
            RESULT $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "TimeUtils.TimeResult(startMs=" + this.getStartMs() + ", endMs=" + this.getEndMs() + ", result=" + this.getResult() + ")";
        }

        public static class TimeResultBuilder<RESULT> {
            private long startMs;
            private long endMs;
            private RESULT result;

            TimeResultBuilder() {
            }

            public TimeResultBuilder<RESULT> startMs(long startMs) {
                this.startMs = startMs;
                return this;
            }

            public TimeResultBuilder<RESULT> endMs(long endMs) {
                this.endMs = endMs;
                return this;
            }

            public TimeResultBuilder<RESULT> result(RESULT result) {
                this.result = result;
                return this;
            }

            public TimeResult<RESULT> build() {
                return new TimeResult<RESULT>(this.startMs, this.endMs, this.result);
            }

            public String toString() {
                return "TimeUtils.TimeResult.TimeResultBuilder(startMs=" + this.startMs + ", endMs=" + this.endMs + ", result=" + this.result + ")";
            }
        }
    }
}

