/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class Range
implements Iterable<Long> {
    private final long start;
    private final long limit;

    public Range(int start, long max) {
        this.start = start;
        this.limit = max;
    }

    public Range(long limit) {
        this.start = 0L;
        this.limit = limit;
    }

    public static Range range(long max) {
        return new Range(max);
    }

    public static Range range(int start, long max) {
        return new Range(start, max);
    }

    public static List<Integer> listOfIntegers(int max) {
        return Range.range(max).listAsIntegers();
    }

    @Override
    public Iterator<Long> iterator() {
        final long max = this.limit;
        return new Iterator<Long>(){
            private long current;
            {
                this.current = Range.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current < max;
            }

            @Override
            public Long next() {
                if (this.hasNext()) {
                    return this.current++;
                }
                throw new NoSuchElementException("Range reached the end");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove values from a Range");
            }
        };
    }

    public List<Integer> listAsIntegers() {
        return IntStream.range(Math.toIntExact(this.start), Math.toIntExact(this.limit)).boxed().collect(Collectors.toList());
    }

    public LongStream toStream() {
        return LongStream.range(this.start, this.limit);
    }
}

