/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.MathUtils;
import io.confluent.csid.utils.Range;
import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.offsets.EncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import io.confluent.parallelconsumer.offsets.RunLengthV1EncodingNotSupported;
import io.confluent.parallelconsumer.offsets.RunLengthV2EncodingNotSupported;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RunLengthEncoder
extends OffsetEncoder {
    private int currentRunLengthSize = 0;
    private boolean previousRunLengthState = false;
    private final List<Integer> runLengthEncodingIntegers;
    private Optional<byte[]> encodedBytes = Optional.empty();
    private static final OffsetEncoding.Version DEFAULT_VERSION = OffsetEncoding.Version.v2;
    long previousRangeIndex = -1L;

    public RunLengthEncoder(OffsetSimultaneousEncoder offsetSimultaneousEncoder, OffsetEncoding.Version newVersion) {
        super(offsetSimultaneousEncoder, newVersion);
        this.runLengthEncodingIntegers = new ArrayList<Integer>();
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                offsetEncoding = OffsetEncoding.RunLength;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.RunLengthV2;
            }
        }
        return offsetEncoding;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                offsetEncoding = OffsetEncoding.RunLengthCompressed;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.RunLengthV2Compressed;
            }
        }
        return offsetEncoding;
    }

    @Override
    public void encodeIncompleteOffset(long relativeOffset) throws EncodingNotSupportedException {
        this.encodeRunLength(false, relativeOffset);
    }

    @Override
    public void encodeCompletedOffset(long relativeOffset) throws EncodingNotSupportedException {
        this.encodeRunLength(true, relativeOffset);
    }

    @Override
    public byte[] serialise() throws EncodingNotSupportedException {
        int n;
        this.addTail();
        switch (this.version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                n = 2;
                break;
            }
            case v2: {
                n = 4;
            }
        }
        int entryWidth = n;
        ByteBuffer runLengthEncodedByteBuffer = ByteBuffer.allocate(this.runLengthEncodingIntegers.size() * entryWidth);
        for (Integer runLength : this.runLengthEncodingIntegers) {
            switch (this.version) {
                case v1: {
                    try {
                        runLengthEncodedByteBuffer.putShort(MathUtils.toShortExact(runLength.intValue()));
                        break;
                    }
                    catch (ArithmeticException e) {
                        throw new RunLengthV1EncodingNotSupported(StringUtils.msg("Run-length too long for Short ({} vs Short max of {})", runLength, (short)Short.MAX_VALUE));
                    }
                }
                case v2: {
                    runLengthEncodedByteBuffer.putInt(runLength);
                }
            }
        }
        byte[] array = runLengthEncodedByteBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    void addTail() {
        this.runLengthEncodingIntegers.add(this.currentRunLengthSize);
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }

    private void encodeRunLength(boolean currentIsComplete, long relativeOffset) throws EncodingNotSupportedException {
        boolean currentOffsetMatchesOurRunLengthState;
        long delta = relativeOffset - this.previousRangeIndex;
        boolean bl = currentOffsetMatchesOurRunLengthState = this.previousRunLengthState == currentIsComplete;
        if (currentOffsetMatchesOurRunLengthState) {
            switch (this.version) {
                case v1: {
                    try {
                        int deltaAsInt = Math.toIntExact(delta);
                        int newRunLength = Math.addExact(this.currentRunLengthSize, deltaAsInt);
                        this.currentRunLengthSize = MathUtils.toShortExact(newRunLength);
                        break;
                    }
                    catch (ArithmeticException e) {
                        throw new RunLengthV1EncodingNotSupported(StringUtils.msg("Run-length too big for Short ({} vs max of {})", (long)this.currentRunLengthSize + delta, (short)Short.MAX_VALUE));
                    }
                }
                case v2: {
                    try {
                        this.currentRunLengthSize = Math.toIntExact(Math.addExact((long)this.currentRunLengthSize, delta));
                        break;
                    }
                    catch (ArithmeticException e) {
                        throw new RunLengthV2EncodingNotSupported(StringUtils.msg("Run-length too big for Integer ({} vs max of {})", this.currentRunLengthSize, Integer.MAX_VALUE));
                    }
                }
            }
        } else {
            this.previousRunLengthState = currentIsComplete;
            this.runLengthEncodingIntegers.add(this.currentRunLengthSize);
            this.currentRunLengthSize = 1;
        }
        this.previousRangeIndex = relativeOffset;
    }

    public List<Long> calculateSucceededActualOffsets(long originalBaseOffset) {
        ArrayList<Long> successfulOffsets = new ArrayList<Long>();
        boolean succeeded = false;
        long offsetPosition = originalBaseOffset;
        for (int run : this.runLengthEncodingIntegers) {
            if (succeeded) {
                for (Long integer : Range.range(run)) {
                    long newGoodOffset = offsetPosition + integer;
                    successfulOffsets.add(newGoodOffset);
                }
            }
            offsetPosition += (long)run;
            succeeded = !succeeded;
        }
        return successfulOffsets;
    }

    @Override
    public String toString() {
        return "RunLengthEncoder(super=" + super.toString() + ", currentRunLengthSize=" + this.currentRunLengthSize + ", previousRunLengthState=" + this.previousRunLengthState + ", runLengthEncodingIntegers=" + this.getRunLengthEncodingIntegers() + ")";
    }

    public List<Integer> getRunLengthEncodingIntegers() {
        return this.runLengthEncodingIntegers;
    }
}

