/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.csid.utils.TimeUtils;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import io.confluent.parallelconsumer.internal.AbstractParallelEoSStreamProcessor;
import io.confluent.parallelconsumer.internal.BrokerPollSystem;
import io.confluent.parallelconsumer.internal.ConsumerManager;
import io.confluent.parallelconsumer.internal.DynamicLoadFactor;
import io.confluent.parallelconsumer.internal.ProducerManager;
import io.confluent.parallelconsumer.internal.ProducerWrapper;
import io.confluent.parallelconsumer.metrics.PCMetrics;
import io.confluent.parallelconsumer.state.WorkManager;
import java.time.Clock;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class PCModule<K, V> {
    protected ParallelConsumerOptions<K, V> optionsInstance;
    protected AbstractParallelEoSStreamProcessor<K, V> parallelEoSStreamProcessor;
    private ProducerWrapper<K, V> producerWrapper;
    private ProducerManager<K, V> producerManager;
    private ConsumerManager<K, V> consumerManager;
    private WorkManager<K, V> workManager;
    private DynamicLoadFactor dynamicLoadFactor;
    private BrokerPollSystem<K, V> brokerPollSystem;
    private PCMetrics pcMetrics;

    public PCModule(ParallelConsumerOptions<K, V> options) {
        this.optionsInstance = options;
    }

    public ParallelConsumerOptions<K, V> options() {
        return this.optionsInstance;
    }

    protected ProducerWrapper<K, V> producerWrap() {
        if (this.producerWrapper == null) {
            this.producerWrapper = new ProducerWrapper<K, V>(this.options());
        }
        return this.producerWrapper;
    }

    protected ProducerManager<K, V> producerManager() {
        if (this.producerManager == null) {
            this.producerManager = new ProducerManager<K, V>(this.producerWrap(), this.consumerManager(), this.workManager(), this.options());
        }
        return this.producerManager;
    }

    public Producer<K, V> producer() {
        return this.optionsInstance.getProducer();
    }

    public Consumer<K, V> consumer() {
        return this.optionsInstance.getConsumer();
    }

    protected ConsumerManager<K, V> consumerManager() {
        if (this.consumerManager == null) {
            this.consumerManager = new ConsumerManager<K, V>(this.optionsInstance.getConsumer(), this.optionsInstance.getOffsetCommitTimeout(), this.optionsInstance.getSaslAuthenticationRetryTimeout(), this.optionsInstance.getSaslAuthenticationExceptionRetryBackoff());
        }
        return this.consumerManager;
    }

    public WorkManager<K, V> workManager() {
        if (this.workManager == null) {
            this.workManager = new WorkManager(this, this.dynamicExtraLoadFactor());
        }
        return this.workManager;
    }

    protected AbstractParallelEoSStreamProcessor<K, V> pc() {
        if (this.parallelEoSStreamProcessor == null) {
            this.parallelEoSStreamProcessor = new ParallelEoSStreamProcessor<K, V>(this.options(), this);
        }
        return this.parallelEoSStreamProcessor;
    }

    protected DynamicLoadFactor dynamicExtraLoadFactor() {
        if (this.dynamicLoadFactor == null) {
            this.dynamicLoadFactor = this.initDynamicLoadFactor();
        }
        return this.dynamicLoadFactor;
    }

    protected BrokerPollSystem<K, V> brokerPoller(AbstractParallelEoSStreamProcessor<K, V> pc) {
        if (this.brokerPollSystem == null) {
            this.brokerPollSystem = new BrokerPollSystem<K, V>(this.consumerManager(), this.workManager(), pc, this.options());
        }
        return this.brokerPollSystem;
    }

    public Clock clock() {
        return TimeUtils.getClock();
    }

    public PCMetrics pcMetrics() {
        if (this.pcMetrics == null) {
            this.pcMetrics = new PCMetrics(this.options().getMeterRegistry(), this.optionsInstance.getMetricsTags(), this.optionsInstance.getPcInstanceTag());
        }
        return this.pcMetrics;
    }

    private DynamicLoadFactor initDynamicLoadFactor() {
        if (this.options().getMessageBufferSize() > 0) {
            int staticLoadFactor = this.options().getMessageBufferSize() / this.options().getTargetAmountOfRecordsInFlight() + (this.options().getMessageBufferSize() % this.options().getTargetAmountOfRecordsInFlight() == 0 ? 0 : 1);
            return new DynamicLoadFactor(staticLoadFactor, staticLoadFactor);
        }
        return new DynamicLoadFactor(this.options().initialLoadFactor, this.options().maximumLoadFactor);
    }

    public void setParallelEoSStreamProcessor(AbstractParallelEoSStreamProcessor<K, V> parallelEoSStreamProcessor) {
        this.parallelEoSStreamProcessor = parallelEoSStreamProcessor;
    }

    public void setWorkManager(WorkManager<K, V> workManager) {
        this.workManager = workManager;
    }
}

