/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class ShardKey {
    public static ShardKey of(WorkContainer<?, ?> wc, ParallelConsumerOptions.ProcessingOrder ordering) {
        return ShardKey.of(wc.getCr(), ordering);
    }

    public static ShardKey of(ConsumerRecord<?, ?> rec, ParallelConsumerOptions.ProcessingOrder ordering) {
        ShardKey shardKey;
        switch (ordering) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case KEY: {
                shardKey = ShardKey.ofKey(rec);
                break;
            }
            case PARTITION: 
            case UNORDERED: {
                shardKey = ShardKey.ofTopicPartition(rec);
            }
        }
        return shardKey;
    }

    public static KeyOrderedKey ofKey(ConsumerRecord<?, ?> rec) {
        return new KeyOrderedKey(rec);
    }

    public static ShardKey ofTopicPartition(ConsumerRecord<?, ?> rec) {
        return new TopicPartitionKey(new TopicPartition(rec.topic(), rec.partition()));
    }

    public String toString() {
        return "ShardKey()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardKey)) {
            return false;
        }
        ShardKey other = (ShardKey)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardKey;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static final class KeyOrderedKey
    extends ShardKey {
        private final TopicPartition topicName;
        private final KeyWithEquals key;

        public KeyOrderedKey(ConsumerRecord<?, ?> rec) {
            this(new TopicPartition(rec.topic(), rec.partition()), rec.key());
        }

        public KeyOrderedKey(TopicPartition topicPartition, Object key) {
            this.key = key instanceof KeyWithEquals ? (KeyWithEquals)key : new KeyWithEquals(key);
            this.topicName = topicPartition;
        }

        public TopicPartition getTopicName() {
            return this.topicName;
        }

        public KeyWithEquals getKey() {
            return this.key;
        }

        @Override
        public String toString() {
            return "ShardKey.KeyOrderedKey(topicName=" + this.getTopicName() + ", key=" + this.getKey() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyOrderedKey)) {
                return false;
            }
            KeyOrderedKey other = (KeyOrderedKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TopicPartition this$topicName = this.getTopicName();
            TopicPartition other$topicName = other.getTopicName();
            if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                return false;
            }
            KeyWithEquals this$key = this.getKey();
            KeyWithEquals other$key = other.getKey();
            return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof KeyOrderedKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TopicPartition $topicName = this.getTopicName();
            result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
            KeyWithEquals $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            return result;
        }
    }

    public static final class TopicPartitionKey
    extends ShardKey {
        private final TopicPartition topicPartition;

        public TopicPartitionKey(TopicPartition topicPartition) {
            this.topicPartition = topicPartition;
        }

        public TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        @Override
        public String toString() {
            return "ShardKey.TopicPartitionKey(topicPartition=" + this.getTopicPartition() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicPartitionKey)) {
                return false;
            }
            TopicPartitionKey other = (TopicPartitionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TopicPartition this$topicPartition = this.getTopicPartition();
            TopicPartition other$topicPartition = other.getTopicPartition();
            return !(this$topicPartition == null ? other$topicPartition != null : !this$topicPartition.equals(other$topicPartition));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TopicPartitionKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TopicPartition $topicPartition = this.getTopicPartition();
            result = result * 59 + ($topicPartition == null ? 43 : $topicPartition.hashCode());
            return result;
        }
    }

    public static final class KeyWithEquals {
        private final Object key;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyWithEquals)) {
                return false;
            }
            KeyWithEquals other = (KeyWithEquals)o;
            if (other.key == null && this.key == null) {
                return true;
            }
            if (other.key == null || this.key == null) {
                return false;
            }
            return Objects.deepEquals(this.key, other.key);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result *= 59;
            if (this.key == null) {
                return result += 43;
            }
            result = this.isArray(this.key) ? (result += this.arrayHashCode(this.key)) : (result += this.key.hashCode());
            return result;
        }

        private int arrayHashCode(Object t) {
            if (t instanceof Object[]) {
                return Arrays.deepHashCode((Object[])t);
            }
            return this.primitiveArrayHashCode(t, t.getClass().getComponentType());
        }

        private int primitiveArrayHashCode(Object a, Class<?> cl) {
            return cl == Byte.TYPE ? Arrays.hashCode((byte[])a) : (cl == Integer.TYPE ? Arrays.hashCode((int[])a) : (cl == Long.TYPE ? Arrays.hashCode((long[])a) : (cl == Character.TYPE ? Arrays.hashCode((char[])a) : (cl == Short.TYPE ? Arrays.hashCode((short[])a) : (cl == Boolean.TYPE ? Arrays.hashCode((boolean[])a) : (cl == Double.TYPE ? Arrays.hashCode((double[])a) : Arrays.hashCode((float[])a)))))));
        }

        private boolean isArray(Object obj) {
            return obj instanceof Object[] || obj instanceof boolean[] || obj instanceof byte[] || obj instanceof short[] || obj instanceof char[] || obj instanceof int[] || obj instanceof long[] || obj instanceof float[] || obj instanceof double[];
        }

        public Object getKey() {
            return this.key;
        }

        public String toString() {
            return "ShardKey.KeyWithEquals(key=" + this.getKey() + ")";
        }

        public KeyWithEquals(Object key) {
            this.key = key;
        }
    }
}

