/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import java.io.Closeable;
import java.time.Duration;

public interface DrainingCloseable
extends Closeable {
    @Override
    default public void close() {
        this.closeDontDrainFirst();
    }

    default public void closeDrainFirst() {
        this.close(DrainingMode.DRAIN);
    }

    default public void closeDontDrainFirst() {
        this.close(DrainingMode.DONT_DRAIN);
    }

    default public void closeDrainFirst(Duration timeout) {
        this.close(timeout, DrainingMode.DRAIN);
    }

    default public void closeDontDrainFirst(Duration timeout) {
        this.close(timeout, DrainingMode.DONT_DRAIN);
    }

    public void close(Duration var1, DrainingMode var2);

    public void close(DrainingMode var1);

    public long workRemaining();

    public static enum DrainingMode {
        DRAIN,
        DONT_DRAIN;

    }
}

