/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingResumingIterator<KEY, VALUE> {
    private static final Logger log = LoggerFactory.getLogger(LoopingResumingIterator.class);
    private Optional<Map.Entry<KEY, VALUE>> head = Optional.empty();
    private Iterator<Map.Entry<KEY, VALUE>> wrappedIterator;
    private final long iterationTargetCount;
    private long iterationCount = 0L;
    private final Optional<KEY> iterationStartingPointKey;
    private final Map<KEY, VALUE> map;
    private boolean isOnSecondPass = false;
    private boolean terminalState = false;
    private boolean startingPointKeyValid = false;

    public static <KKEY, VVALUE> LoopingResumingIterator<KKEY, VVALUE> build(KKEY startingKey, Map<KKEY, VVALUE> map) {
        return new LoopingResumingIterator<KKEY, VVALUE>(Optional.ofNullable(startingKey), map);
    }

    public LoopingResumingIterator(Optional<KEY> startingKey, Map<KEY, VALUE> map) {
        this.iterationStartingPointKey = startingKey;
        this.map = map;
        this.wrappedIterator = map.entrySet().iterator();
        this.iterationTargetCount = map.size();
        if (startingKey.isPresent()) {
            this.head = this.advanceToStartingPointAndGet(startingKey.get());
            if (this.head.isPresent()) {
                this.startingPointKeyValid = true;
            } else {
                this.resetIteratorToZero();
            }
        }
    }

    public LoopingResumingIterator(Map<KEY, VALUE> map) {
        this(Optional.empty(), map);
    }

    public Optional<Map.Entry<KEY, VALUE>> next() {
        ++this.iterationCount;
        if (this.terminalState) {
            return Optional.empty();
        }
        if (this.head.isPresent()) {
            Optional<Map.Entry<KEY, VALUE>> headSave = this.takeHeadValue();
            return headSave;
        }
        if (this.wrappedIterator.hasNext()) {
            boolean numberElementsReturnedExceeded;
            Map.Entry<KEY, VALUE> next = this.wrappedIterator.next();
            boolean onSecondPassAndReachedStartingPoint = this.iterationStartingPointKey.equals(Optional.of(next.getKey()));
            boolean bl = numberElementsReturnedExceeded = this.iterationCount > this.iterationTargetCount + 1L;
            if (onSecondPassAndReachedStartingPoint || numberElementsReturnedExceeded) {
                this.terminalState = true;
                return Optional.empty();
            }
            return Optional.ofNullable(next);
        }
        if (this.iterationStartingPointKey.isPresent() && this.startingPointKeyValid && !this.isOnSecondPass) {
            this.resetIteratorToZero();
            this.isOnSecondPass = true;
            return this.next();
        }
        return Optional.empty();
    }

    private Optional<Map.Entry<KEY, VALUE>> takeHeadValue() {
        Optional<Map.Entry<KEY, VALUE>> headSave = this.head;
        this.head = Optional.empty();
        return headSave;
    }

    private Optional<Map.Entry<KEY, VALUE>> advanceToStartingPointAndGet(Object startingPointObject) {
        while (this.wrappedIterator.hasNext()) {
            Map.Entry<KEY, VALUE> next = this.wrappedIterator.next();
            if (next.getKey() != startingPointObject) continue;
            return Optional.of(next);
        }
        return Optional.empty();
    }

    private void resetIteratorToZero() {
        this.wrappedIterator = this.map.entrySet().iterator();
    }

    public Optional<KEY> getIterationStartingPointKey() {
        return this.iterationStartingPointKey;
    }
}

