/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.offsets.BitSetEncoder;
import io.confluent.parallelconsumer.offsets.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.ByteBufferEncoder;
import io.confluent.parallelconsumer.offsets.EncodedOffsetPair;
import io.confluent.parallelconsumer.offsets.EncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.NoEncodingPossibleException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.RunLengthEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetSimultaneousEncoder {
    private static final Logger log = LoggerFactory.getLogger(OffsetSimultaneousEncoder.class);
    public static final int LARGE_ENCODED_SIZE_THRESHOLD_BYTES = 200;
    public static final int LARGE_INPUT_MAP_SIZE = 2000;
    private final SortedSet<Long> incompleteOffsets;
    private final long lowWaterMark;
    private final long lengthBetweenBaseAndHighOffset;
    Map<OffsetEncoding, byte[]> encodingMap = new EnumMap<OffsetEncoding, byte[]>(OffsetEncoding.class);
    SortedSet<EncodedOffsetPair> sortedEncodings = new TreeSet<EncodedOffsetPair>();
    public static boolean compressionForced = false;
    public static final String COMPRESSION_FORCED_RESOURCE_LOCK = "Value doesn't matter, just needs a constant";
    private final ConcurrentHashMap.KeySetView<OffsetEncoder, Boolean> activeEncoders;

    public OffsetSimultaneousEncoder(long baseOffsetToCommit, long highestSucceededOffset, SortedSet<Long> incompleteOffsets) {
        this.lowWaterMark = baseOffsetToCommit;
        this.incompleteOffsets = incompleteOffsets;
        if (highestSucceededOffset == -1L) {
            highestSucceededOffset = baseOffsetToCommit;
        }
        highestSucceededOffset = this.maybeRaiseOffsetHighestSucceeded(baseOffsetToCommit, highestSucceededOffset);
        this.lengthBetweenBaseAndHighOffset = highestSucceededOffset - this.lowWaterMark + 1L;
        if (this.lengthBetweenBaseAndHighOffset < 0L) {
            throw new IllegalStateException(StringUtils.msg("Cannot have negative length encoding (calculated length: {}, base offset to commit: {}, highest succeeded offset: {})", this.lengthBetweenBaseAndHighOffset, baseOffsetToCommit, highestSucceededOffset));
        }
        this.activeEncoders = this.initEncoders();
    }

    private long maybeRaiseOffsetHighestSucceeded(long baseOffsetToCommit, long highestSucceededOffset) {
        boolean gapLargerThanOne;
        long nextExpectedMinusOne = baseOffsetToCommit - 1L;
        boolean bl = gapLargerThanOne = highestSucceededOffset < nextExpectedMinusOne;
        if (gapLargerThanOne) {
            long gap = nextExpectedMinusOne - highestSucceededOffset;
            log.debug("Gap detected in partition (highest succeeded: {} while next expected poll offset: {} - gap is {}), probably tx markers. Moving highest succeeded to next expected - 1", new Object[]{highestSucceededOffset, nextExpectedMinusOne, gap});
            highestSucceededOffset = nextExpectedMinusOne;
        }
        return highestSucceededOffset;
    }

    private ConcurrentHashMap.KeySetView<OffsetEncoder, Boolean> initEncoders() {
        ConcurrentHashMap.KeySetView<OffsetEncoder, Boolean> newEncoders = ConcurrentHashMap.newKeySet();
        if (this.lengthBetweenBaseAndHighOffset > 2000L) {
            log.trace("Relatively large input map size: {} (start: {} end: {})", new Object[]{this.lengthBetweenBaseAndHighOffset, this.lowWaterMark, this.getEndOffsetExclusive()});
        }
        this.addBitsetEncoder(newEncoders, OffsetEncoding.Version.v1);
        this.addBitsetEncoder(newEncoders, OffsetEncoding.Version.v2);
        newEncoders.add(new RunLengthEncoder(this, OffsetEncoding.Version.v1));
        newEncoders.add(new RunLengthEncoder(this, OffsetEncoding.Version.v2));
        return newEncoders;
    }

    private void addBitsetEncoder(ConcurrentHashMap.KeySetView<OffsetEncoder, Boolean> newEncoders, OffsetEncoding.Version version) {
        try {
            newEncoders.add(new BitSetEncoder(this.lengthBetweenBaseAndHighOffset, this, version));
        }
        catch (BitSetEncodingNotSupportedException a) {
            log.debug("Cannot construct {} version {} : {}", new Object[]{BitSetEncoder.class.getSimpleName(), version, a.getMessage()});
        }
    }

    private long getEndOffsetExclusive() {
        return this.lowWaterMark + this.lengthBetweenBaseAndHighOffset;
    }

    void addByteBufferEncoder() {
        try {
            this.activeEncoders.add(new ByteBufferEncoder(this.lengthBetweenBaseAndHighOffset, this));
        }
        catch (ArithmeticException a) {
            log.warn("Cannot use {} encoder ({})", (Object)BitSetEncoder.class.getSimpleName(), (Object)a.getMessage());
        }
    }

    public OffsetSimultaneousEncoder invoke() {
        log.debug("Starting encode of incompletes, base offset is: {}, end offset is: {}", (Object)this.lowWaterMark, (Object)this.getEndOffsetExclusive());
        log.trace("Incompletes are: {}", this.incompleteOffsets);
        log.debug("Encode loop offset start,end: [{},{}] length: {}", new Object[]{this.lowWaterMark, this.getEndOffsetExclusive(), this.lengthBetweenBaseAndHighOffset});
        Range relativeOffsetsLongRange = Range.range(this.lengthBetweenBaseAndHighOffset);
        relativeOffsetsLongRange.forEach(relativeOffset -> {
            long actualOffset = this.lowWaterMark + relativeOffset;
            boolean isIncomplete = this.incompleteOffsets.contains(actualOffset);
            this.activeEncoders.forEach(encoder -> {
                try {
                    if (isIncomplete) {
                        log.trace("Found an incomplete offset {}", (Object)actualOffset);
                        encoder.encodeIncompleteOffset((long)relativeOffset);
                    } else {
                        encoder.encodeCompletedOffset((long)relativeOffset);
                    }
                }
                catch (EncodingNotSupportedException e) {
                    log.debug("Error encoding offset {} with encoder {}, removing encoder", new Object[]{actualOffset, encoder, e});
                    this.activeEncoders.remove(encoder);
                }
            });
        });
        this.registerEncodings(this.activeEncoders);
        log.debug("In order: {}", this.sortedEncodings);
        return this;
    }

    private void registerEncodings(Set<? extends OffsetEncoder> encoders) {
        ArrayList<OffsetEncoder> toRemove = new ArrayList<OffsetEncoder>();
        for (OffsetEncoder offsetEncoder : encoders) {
            try {
                offsetEncoder.register();
            }
            catch (EncodingNotSupportedException e) {
                log.debug("Removing {} encoder, not supported ({})", (Object)offsetEncoder.getEncodingType().description(), (Object)e.getMessage());
                toRemove.add(offsetEncoder);
            }
        }
        toRemove.forEach(encoders::remove);
        boolean noEncodingsAreSmallEnough = encoders.stream().noneMatch(OffsetEncoder::quiteSmall);
        if (noEncodingsAreSmallEnough || compressionForced) {
            encoders.forEach(OffsetEncoder::registerCompressed);
        }
    }

    public byte[] packSmallest() throws NoEncodingPossibleException {
        if (this.sortedEncodings.isEmpty()) {
            throw new NoEncodingPossibleException("No encodings could be used");
        }
        EncodedOffsetPair best = this.sortedEncodings.first();
        log.debug("Compression chosen is: {}", (Object)best.encoding.name());
        return this.packEncoding(best);
    }

    byte[] packEncoding(EncodedOffsetPair best) {
        boolean magicByteSize = true;
        ByteBuffer result = ByteBuffer.allocate(1 + best.data.capacity());
        result.put(best.encoding.magicByte);
        result.put(best.data);
        return result.array();
    }

    public String toString() {
        return "OffsetSimultaneousEncoder(lowWaterMark=" + this.lowWaterMark + ", lengthBetweenBaseAndHighOffset=" + this.lengthBetweenBaseAndHighOffset + ", compressionForced=" + compressionForced + ")";
    }

    public SortedSet<Long> getIncompleteOffsets() {
        return this.incompleteOffsets;
    }

    public Map<OffsetEncoding, byte[]> getEncodingMap() {
        return this.encodingMap;
    }

    public SortedSet<EncodedOffsetPair> getSortedEncodings() {
        return this.sortedEncodings;
    }
}

