/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import io.confluent.csid.utils.BackportUtils;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public final class OffsetSimpleSerialisation {
    private static final Logger log = LoggerFactory.getLogger(OffsetSimpleSerialisation.class);

    static String encodeAsJavaObjectStream(Set<Long> incompleteOffsets) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(baos);){
            os.writeObject(incompleteOffsets);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    private static TreeSet<Long> deserialiseJavaWriteObject(byte[] decode) throws IOException, ClassNotFoundException {
        Set raw;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(decode));){
            raw = (Set)objectInputStream.readObject();
        }
        return new TreeSet<Long>(raw);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] compressSnappy(byte[] bytes) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (SnappyOutputStream stream = new SnappyOutputStream((OutputStream)out);){
                stream.write(bytes);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    static ByteBuffer decompressSnappy(ByteBuffer input) throws IOException {
        try (SnappyInputStream snappy = new SnappyInputStream((InputStream)new ByteBufferInputStream(input));){
            byte[] bytes = BackportUtils.readFully((InputStream)snappy);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            return byteBuffer;
        }
    }

    static String base64(ByteArrayOutputStream out) {
        byte[] src = out.toByteArray();
        return OffsetSimpleSerialisation.base64(src);
    }

    static byte[] compressZstd(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZstdOutputStream zstream = new ZstdOutputStream((OutputStream)out);){
            zstream.write(bytes);
        }
        return out.toByteArray();
    }

    static byte[] compressGzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream zstream = new GZIPOutputStream(out);){
            zstream.write(bytes);
        }
        return out.toByteArray();
    }

    static String base64(byte[] src) {
        byte[] encode = Base64.getEncoder().encode(src);
        String out = new String(encode, OffsetMapCodecManager.CHARSET_TO_USE);
        log.trace("Final b64 size: {}", (Object)out.length());
        return out;
    }

    static byte[] decodeBase64(String b64) {
        byte[] bytes = b64.getBytes(OffsetMapCodecManager.CHARSET_TO_USE);
        return Base64.getDecoder().decode(bytes);
    }

    static ByteBuffer decompressZstd(ByteBuffer input) throws IOException {
        try (ZstdInputStream zstream = new ZstdInputStream((InputStream)new ByteBufferInputStream(input));){
            byte[] bytes = BackportUtils.readFully((InputStream)zstream);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            return byteBuffer;
        }
    }

    static byte[] decompressGzip(ByteBuffer input) throws IOException {
        try (GZIPInputStream gstream = new GZIPInputStream((InputStream)new ByteBufferInputStream(input));){
            byte[] byArray = BackportUtils.readFully(gstream);
            return byArray;
        }
    }

    static String deserialiseByteArrayToBitMapString(ByteBuffer data) {
        data.rewind();
        StringBuilder sb = new StringBuilder(data.capacity());
        while (data.hasRemaining()) {
            byte b = data.get();
            if (b == 1) {
                sb.append('x');
                continue;
            }
            sb.append('o');
        }
        return sb.toString();
    }

    private OffsetSimpleSerialisation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

