/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.metrics;

import io.confluent.parallelconsumer.metrics.PCMetricsDef;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.search.Search;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCMetrics {
    private static final Logger log = LoggerFactory.getLogger(PCMetrics.class);
    private MeterRegistry meterRegistry;
    private List<Meter.Id> registeredMeters = new ArrayList<Meter.Id>();
    private Iterable<Tag> commonTags;
    private Tag instanceTag;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final boolean isNoop;

    public PCMetrics(MeterRegistry meterRegistry, Iterable<Tag> commonTags, String instanceTag) {
        if (meterRegistry == null) {
            this.isNoop = true;
            this.meterRegistry = new CompositeMeterRegistry();
        } else {
            this.isNoop = false;
            this.meterRegistry = meterRegistry;
        }
        this.instanceTag = instanceTag != null ? Tag.of((String)"pcinstance", (String)instanceTag) : this.generateUniqueInstanceTag();
        this.commonTags = this.combine(this.instanceTag, commonTags);
        this.isClosed.set(false);
    }

    private Iterable<Tag> combine(Tag instanceTag, Iterable<Tag> commonTags) {
        HashSet<String> tagKeys = new HashSet<String>();
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tagKeys.add(instanceTag.getKey());
        tags.add(instanceTag);
        commonTags.forEach(tag -> {
            if (!tagKeys.contains(tag.getKey())) {
                tagKeys.add(tag.getKey());
                tags.add((Tag)tag);
            } else {
                log.warn("Duplicate metrics tag specified : {}", (Object)tag.getKey());
            }
        });
        return tags;
    }

    private Tag generateUniqueInstanceTag() {
        Tag tagToUse;
        boolean inUse;
        do {
            tagToUse = Tag.of((String)"pcinstance", (String)UUID.randomUUID().toString());
        } while (inUse = Search.in((MeterRegistry)this.meterRegistry).tags(Collections.singleton(this.instanceTag)).meter() != null);
        return tagToUse;
    }

    public Counter getCounterFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        Counter counter = Counter.builder((String)metricDef.getName()).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(counter.getId());
        return counter;
    }

    public Timer getTimerFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        Timer timer = Timer.builder((String)metricDef.getName()).publishPercentiles(new double[]{0.0, 0.5, 0.75, 0.95, 0.99, 0.999}).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(timer.getId());
        return timer;
    }

    public <T> Gauge gaugeFromMetricDef(PCMetricsDef metricDef, T stateObject, ToDoubleFunction<T> valueFunction, Tag ... additionalTags) {
        Gauge gauge = Gauge.builder((String)metricDef.getName(), stateObject, valueFunction).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).strongReference(true).register(this.meterRegistry);
        this.registeredMeters.add(gauge.getId());
        return gauge;
    }

    public DistributionSummary getDistributionSummaryFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        DistributionSummary distributionSummary = DistributionSummary.builder((String)metricDef.getName()).publishPercentiles(new double[]{0.0, 0.5, 0.75, 0.95, 0.99, 0.999}).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(distributionSummary.getId());
        return distributionSummary;
    }

    public synchronized void close() {
        if (this.isClosed.getAndSet(true)) {
            log.warn("Trying to close PCMetrics instance that is already closed.");
            return;
        }
        log.debug("Closing PCMetrics");
        this.registeredMeters.forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
        this.registeredMeters.clear();
        if (this.isNoop) {
            this.meterRegistry.close();
        }
    }

    public synchronized void removeMeter(Meter meter) {
        if (meter != null) {
            this.removeMeter(meter.getId());
        }
    }

    private void removeMeter(Meter.Id meterId) {
        if (this.isClosed.get()) {
            log.debug("Trying to remove meter when metrics subsystem is already closed. Meter Id {}", (Object)meterId);
            return;
        }
        log.debug("Removing meter: {}", (Object)meterId);
        this.meterRegistry.remove(meterId);
        this.registeredMeters.remove(meterId);
    }

    public void removeMetersByPrefixAndCommonTags(String meterNamePrefix) {
        if (this.isClosed.get()) {
            log.debug("Trying to remove meters when metrics subsystem is already closed.");
            return;
        }
        Search.in((MeterRegistry)this.meterRegistry).name(name -> name.startsWith(meterNamePrefix)).tags(this.commonTags).meters().forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public Iterable<Tag> getCommonTags() {
        return this.commonTags;
    }

    public Tag getInstanceTag() {
        return this.instanceTag;
    }
}

