/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.state.ConsumerRecordId;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;

public class RecordContext<K, V> {
    protected final WorkContainer<K, V> workContainer;
    private final ConsumerRecord<K, V> consumerRecord;

    public RecordContext(WorkContainer<K, V> wc) {
        this.consumerRecord = wc.getCr();
        this.workContainer = wc;
    }

    public ConsumerRecordId getRecordId() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
        return new ConsumerRecordId(topicPartition, this.offset());
    }

    public int getNumberOfFailedAttempts() {
        return this.workContainer.getNumberOfFailedAttempts();
    }

    public Optional<Instant> getLastFailureAt() {
        return this.workContainer.getLastFailedAt();
    }

    public Optional<Instant> getSucceededAt() {
        return this.workContainer.getSucceededAt();
    }

    public static <K, V> RecordContextBuilder<K, V> builder() {
        return new RecordContextBuilder();
    }

    public RecordContextBuilder<K, V> toBuilder() {
        return new RecordContextBuilder<K, V>().workContainer(this.workContainer).consumerRecord(this.consumerRecord);
    }

    public RecordContext(WorkContainer<K, V> workContainer, ConsumerRecord<K, V> consumerRecord) {
        this.workContainer = workContainer;
        this.consumerRecord = consumerRecord;
    }

    public String toString() {
        return "RecordContext(workContainer=" + this.getWorkContainer() + ", consumerRecord=" + this.getConsumerRecord() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordContext)) {
            return false;
        }
        RecordContext other = (RecordContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WorkContainer<K, V> this$workContainer = this.getWorkContainer();
        WorkContainer<K, V> other$workContainer = other.getWorkContainer();
        if (this$workContainer == null ? other$workContainer != null : !((Object)this$workContainer).equals(other$workContainer)) {
            return false;
        }
        ConsumerRecord<K, V> this$consumerRecord = this.getConsumerRecord();
        ConsumerRecord<K, V> other$consumerRecord = other.getConsumerRecord();
        return !(this$consumerRecord == null ? other$consumerRecord != null : !this$consumerRecord.equals(other$consumerRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkContainer<K, V> $workContainer = this.getWorkContainer();
        result = result * 59 + ($workContainer == null ? 43 : ((Object)$workContainer).hashCode());
        ConsumerRecord<K, V> $consumerRecord = this.getConsumerRecord();
        result = result * 59 + ($consumerRecord == null ? 43 : $consumerRecord.hashCode());
        return result;
    }

    protected WorkContainer<K, V> getWorkContainer() {
        return this.workContainer;
    }

    public ConsumerRecord<K, V> getConsumerRecord() {
        return this.consumerRecord;
    }

    public String topic() {
        return this.getConsumerRecord().topic();
    }

    public int partition() {
        return this.getConsumerRecord().partition();
    }

    public Headers headers() {
        return this.getConsumerRecord().headers();
    }

    public K key() {
        return (K)this.getConsumerRecord().key();
    }

    public V value() {
        return (V)this.getConsumerRecord().value();
    }

    public long offset() {
        return this.getConsumerRecord().offset();
    }

    public long timestamp() {
        return this.getConsumerRecord().timestamp();
    }

    public TimestampType timestampType() {
        return this.getConsumerRecord().timestampType();
    }

    public int serializedKeySize() {
        return this.getConsumerRecord().serializedKeySize();
    }

    public int serializedValueSize() {
        return this.getConsumerRecord().serializedValueSize();
    }

    public Optional<Integer> leaderEpoch() {
        return this.getConsumerRecord().leaderEpoch();
    }

    public static class RecordContextBuilder<K, V> {
        private WorkContainer<K, V> workContainer;
        private ConsumerRecord<K, V> consumerRecord;

        RecordContextBuilder() {
        }

        public RecordContextBuilder<K, V> workContainer(WorkContainer<K, V> workContainer) {
            this.workContainer = workContainer;
            return this;
        }

        public RecordContextBuilder<K, V> consumerRecord(ConsumerRecord<K, V> consumerRecord) {
            this.consumerRecord = consumerRecord;
            return this;
        }

        public RecordContext<K, V> build() {
            return new RecordContext<K, V>(this.workContainer, this.consumerRecord);
        }

        public String toString() {
            return "RecordContext.RecordContextBuilder(workContainer=" + this.workContainer + ", consumerRecord=" + this.consumerRecord + ")";
        }
    }
}

