/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.parallelconsumer.internal.InternalRuntimeException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaUtils {
    public static <T> Optional<T> getLast(List<T> someList) {
        if (someList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(someList.get(someList.size() - 1));
    }

    public static <T> Optional<T> getFirst(List<T> someList) {
        return someList.isEmpty() ? Optional.empty() : Optional.of(someList.get(0));
    }

    public static <T> Optional<T> getOnlyOne(Map<String, T> stringMapMap) {
        if (stringMapMap.isEmpty()) {
            return Optional.empty();
        }
        Collection<T> values = stringMapMap.values();
        if (values.size() > 1) {
            throw new InternalRuntimeException("More than one element");
        }
        return Optional.of(values.iterator().next());
    }

    public static Duration max(Duration left, Duration right) {
        long expectedDurationOfClose = Math.max(left.toMillis(), right.toMillis());
        return Duration.ofMillis(expectedDurationOfClose);
    }

    public static boolean isGreaterThan(Duration compare, Duration to) {
        return compare.compareTo(to) > 0;
    }

    public static <K, V1, V2> Map<K, V2> remap(Map<K, V1> map, Function<? super V1, ? extends V2> function) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> function.apply((Object)e.getValue())));
    }

    public static List<String> getRandom(List<String> list, int quantity) {
        if (list.size() < quantity) {
            throw new IllegalArgumentException("List size is less than quantity");
        }
        return JavaUtils.createRandomIntStream(list.size()).limit(quantity).map(list::get).collect(Collectors.toList());
    }

    private static Stream<Integer> createRandomIntStream(int range) {
        Random random = new Random();
        return Stream.generate(() -> random.nextInt(range));
    }

    public static <T> Collector<T, ?, TreeSet<T>> toTreeSet() {
        return Collectors.toCollection(TreeSet::new);
    }

    private JavaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

