/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.metrics;

import io.confluent.parallelconsumer.ParallelConsumer;
import io.confluent.parallelconsumer.internal.State;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum PCMetricsDef {
    USER_FUNCTION_PROCESSING_TIME("user.function.processing.time", "User function processing time", PCMetricsSubsystem.PROCESSOR, MeterType.TIMER, new ParallelConsumer.Tuple[0]),
    DYNAMIC_EXTRA_LOAD_FACTOR("dynamic.load.factor", "Dynamic load factor - load of processing buffers", PCMetricsSubsystem.PROCESSOR, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    INFLIGHT_RECORDS("inflight.records", "Total number of records currently being processed or waiting for retry", PCMetricsSubsystem.WORK_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    WAITING_RECORDS("waiting.records", "Total number of records waiting to be selected for processing", PCMetricsSubsystem.WORK_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    PROCESSED_RECORDS("processed.records", "Total number of records successfully processed", PCMetricsSubsystem.WORK_MANAGER, MeterType.COUNTER, PCMetricsDef.topicPartitionTags()),
    FAILED_RECORDS("failed.records", "Total number of records failed to be processed", PCMetricsSubsystem.WORK_MANAGER, MeterType.COUNTER, PCMetricsDef.topicPartitionTags()),
    SLOW_RECORDS("slow.records", "Total number of records that spent more than the configured time threshold in the waiting queue. This setting defaults to 10 seconds", PCMetricsSubsystem.WORK_MANAGER, MeterType.COUNTER, PCMetricsDef.topicPartitionTags()),
    PC_POLLER_STATUS("poller.status", "PC Broker Poller Status, reported as number with following mapping - " + PCMetricsDef.getStateToValueListing(), PCMetricsSubsystem.BROKER_POLLER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    PC_STATUS("status", "PC Status, reported as number with following mapping - " + PCMetricsDef.getStateToValueListing(), PCMetricsSubsystem.PROCESSOR, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    NUM_PAUSED_PARTITIONS("partitions.paused", "Number of paused partitions", PCMetricsSubsystem.BROKER_POLLER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    NUMBER_OF_SHARDS("shards", "Number of shards", PCMetricsSubsystem.SHARD_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    INCOMPLETE_OFFSETS_TOTAL("incomplete.offsets.total", "Total number of incomplete offsets", PCMetricsSubsystem.SHARD_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    SHARDS_SIZE("shards.size", "Number of records queued for processing across all shards", PCMetricsSubsystem.SHARD_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    NUMBER_OF_PARTITIONS("partitions.number", "Number of partitions", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, new ParallelConsumer.Tuple[0]),
    PARTITION_INCOMPLETE_OFFSETS("partition.incomplete.offsets", "Number of incomplete offsets in the partition", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    PARTITION_HIGHEST_COMPLETED_OFFSET("partition.highest.completed.offset", "Highest completed offset in the partition", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    PARTITION_HIGHEST_SEQUENTIAL_SUCCEEDED_OFFSET("partition.highest.sequential.succeeded.offset", "Highest sequential succeeded offset in the partition", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    PARTITION_HIGHEST_SEEN_OFFSET("partition.highest.seen.offset", "Highest seen / consumed offset in the partition", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    PARTITION_LAST_COMMITTED_OFFSET("partition.latest.committed.offset", "Latest committed offset in the partition", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    PARTITION_ASSIGNMENT_EPOCH("partition.assignment.epoch", "Epoch of partition assignment", PCMetricsSubsystem.PARTITION_MANAGER, MeterType.GAUGE, PCMetricsDef.topicPartitionTags()),
    OFFSETS_ENCODING_TIME("offsets.encoding.time", "Time spend encoding offsets", PCMetricsSubsystem.OFFSET_ENCODER, MeterType.TIMER, new ParallelConsumer.Tuple[0]),
    OFFSETS_ENCODING_USAGE("offsets.encoding.usage", "Offset encoding usage per encoding type", PCMetricsSubsystem.OFFSET_ENCODER, MeterType.COUNTER, PCMetricsDef.tag("codec", "BitSet|BitSetCompressed|BitSetV2Compressed|RunLength")),
    METADATA_SPACE_USED("metadata.space.used", "Ratio between offset metadata payload size and available space", PCMetricsSubsystem.OFFSET_ENCODER, MeterType.DISTRIBUTION_SUMMARY, new ParallelConsumer.Tuple[0]),
    PAYLOAD_RATIO_USED("payload.ratio.used", "Ratio between offset metadata payload size and offsets encoded", PCMetricsSubsystem.OFFSET_ENCODER, MeterType.DISTRIBUTION_SUMMARY, new ParallelConsumer.Tuple[0]);

    private static final String SUBSYSTEM_TAG_KEY = "subsystem";
    public static final String METER_PREFIX = "pc.";
    private final String name;
    private final String description;
    private final ParallelConsumer.Tuple<String, String>[] tags;
    private final MeterType type;
    private Tag subsystem;

    private static String getStateToValueListing() {
        return Arrays.stream(State.values()).map(state -> state.getValue() + ":" + (Object)state).collect(Collectors.joining(", "));
    }

    private static ParallelConsumer.Tuple<String, String>[] topicPartitionTags() {
        return new ParallelConsumer.Tuple[]{PCMetricsDef.tag("topic", "topicName"), PCMetricsDef.tag("partition", "partitionNumber")};
    }

    private PCMetricsDef(String name, String description, PCMetricsSubsystem subsystem, MeterType type, ParallelConsumer.Tuple<String, String> ... tags) {
        this.name = METER_PREFIX + name;
        this.description = description;
        this.tags = tags;
        if (subsystem != null) {
            this.subsystem = Tag.of((String)SUBSYSTEM_TAG_KEY, (String)subsystem.subsystemTag);
        }
        this.type = type;
    }

    public Tags getSubsystemAsTagsOrEmpty() {
        if (this.subsystem == null) {
            return Tags.empty();
        }
        return Tags.of((Tag[])new Tag[]{this.subsystem});
    }

    public static void main(String[] args) {
        System.out.println(PCMetricsDef.toMarkdown());
    }

    private static String toCamelCase(String s) {
        return Arrays.stream(s.replace("_", " ").split(" ")).map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private static String formatMetricDef(PCMetricsDef metricsDef) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("**%s**%n%n", PCMetricsDef.toCamelCase(metricsDef.name())));
        sb.append(String.format("%s `%s%s`%n%n", PCMetricsDef.toCamelCase(metricsDef.type.name()), metricsDef.name, PCMetricsDef.formatTagsAndSubsystem(metricsDef)));
        sb.append(metricsDef.description);
        sb.append("\n\n");
        return sb.toString();
    }

    private static String formatTagsAndSubsystem(PCMetricsDef metricsDef) {
        String res = "";
        if (metricsDef.subsystem != null) {
            res = res + String.format("%s=%s", metricsDef.subsystem.getKey(), metricsDef.subsystem.getValue());
        }
        if (metricsDef.tags != null && metricsDef.tags.length > 0) {
            if (res.length() > 0) {
                res = res + ", ";
            }
            res = res + PCMetricsDef.joinTagsForRendering(metricsDef.tags);
        }
        if (res.length() > 0) {
            res = "{" + res + "}";
        }
        return res;
    }

    private static String toMarkdown() {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(PCMetricsSubsystem.values()).forEach(sub -> {
            sb.append(PCMetricsDef.formatSubsystem(sub));
            Arrays.stream(PCMetricsDef.values()).filter(def -> def.subsystem != null && def.subsystem.getValue().equals(((PCMetricsSubsystem)sub).subsystemTag)).forEach(v -> sb.append(PCMetricsDef.formatMetricDef(v)));
        });
        return sb.toString();
    }

    private static String formatSubsystem(PCMetricsSubsystem sub) {
        return String.format("==== %s%n%n", PCMetricsDef.toCamelCase(sub.name()));
    }

    private static String joinTagsForRendering(ParallelConsumer.Tuple<String, String>[] tags) {
        if (tags == null || tags.length == 0) {
            return "";
        }
        return Arrays.stream(tags).map(tag -> (String)tag.getLeft() + "=\"" + (String)tag.getRight() + "\"").collect(Collectors.joining(", "));
    }

    static ParallelConsumer.Tuple<String, String> tag(String key, String valueToken) {
        return ParallelConsumer.Tuple.pairOf(key, valueToken);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Tag getSubsystem() {
        return this.subsystem;
    }

    public static enum PCMetricsSubsystem {
        PARTITION_MANAGER("partitions"),
        PROCESSOR("processor"),
        SHARD_MANAGER("shardmanager"),
        WORK_MANAGER("workmanager"),
        BROKER_POLLER("poller"),
        OFFSET_ENCODER("offsetencoder");

        private final String subsystemTag;

        private PCMetricsSubsystem(String subsystemTag) {
            this.subsystemTag = subsystemTag;
        }
    }

    public static enum MeterType {
        COUNTER,
        TIMER,
        GAUGE,
        DISTRIBUTION_SUMMARY;

    }
}

