/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.state.PartitionState;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovedPartitionState<K, V>
extends PartitionState<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RemovedPartitionState.class);
    private static final NavigableMap READ_ONLY_EMPTY_MAP = Collections.unmodifiableNavigableMap(new ConcurrentSkipListMap());
    private static final Set READ_ONLY_EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final PartitionState singleton = new RemovedPartitionState();
    public static final String NO_OP = "no-op";

    public RemovedPartitionState() {
        super(null, OffsetMapCodecManager.HighestOffsetAndIncompletes.of());
    }

    public static PartitionState getSingleton() {
        return singleton;
    }

    @Override
    public boolean isRemoved() {
        return true;
    }

    @Override
    public TopicPartition getTp() {
        return null;
    }

    @Override
    public void addWorkContainer(WorkContainer<K, V> wc) {
        log.warn("Dropping new work container for partition no longer assigned. WC: {}", wc);
    }

    @Override
    boolean isAllowedMoreRecords() {
        log.debug(NO_OP);
        return true;
    }

    @Override
    public Set<Long> getIncompleteOffsetsBelowHighestSucceeded() {
        log.debug(NO_OP);
        return READ_ONLY_EMPTY_SET;
    }

    @Override
    public long getOffsetHighestSeen() {
        log.debug(NO_OP);
        return -1L;
    }

    @Override
    public long getOffsetHighestSucceeded() {
        log.debug(NO_OP);
        return -1L;
    }

    @Override
    public boolean isRecordPreviouslyCompleted(ConsumerRecord<K, V> rec) {
        log.debug("Ignoring previously completed request for partition no longer assigned. Partition: {}", (Object)KafkaUtils.toTopicPartition(rec));
        return false;
    }

    @Override
    public boolean hasWorkInCommitQueue() {
        return false;
    }

    @Override
    public int getCommitQueueSize() {
        return 0;
    }

    @Override
    public void onSuccess(WorkContainer<K, V> work) {
        log.debug("Dropping completed work container for partition no longer assigned. WC: {}, partition: {}", work, (Object)work.getTopicPartition());
    }
}

