/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OffsetEncoding {
    ByteArray(Version.v1, 76),
    ByteArrayCompressed(Version.v1, -18),
    BitSet(Version.v1, 108),
    BitSetCompressed(Version.v1, 97),
    RunLength(Version.v1, 110),
    RunLengthCompressed(Version.v1, 74),
    BitSetV2(Version.v2, 111),
    BitSetV2Compressed(Version.v2, 115),
    RunLengthV2(Version.v2, 101),
    RunLengthV2Compressed(Version.v2, 112);

    public final Version version;
    public final byte magicByte;
    private static final Map<Byte, OffsetEncoding> magicMap;

    public static OffsetEncoding decode(byte magic) {
        OffsetEncoding encoding = magicMap.get(magic);
        if (encoding == null) {
            throw new RuntimeException("Unexpected magic: " + magic);
        }
        return encoding;
    }

    public String description() {
        return this.name() + ":" + (Object)((Object)this.version);
    }

    public String toString() {
        return "OffsetEncoding." + this.name() + "(version=" + (Object)((Object)this.version) + ", magicByte=" + this.getMagicByte() + ")";
    }

    private OffsetEncoding(Version version, byte magicByte) {
        this.version = version;
        this.magicByte = magicByte;
    }

    public byte getMagicByte() {
        return this.magicByte;
    }

    static {
        magicMap = Arrays.stream(OffsetEncoding.values()).collect(Collectors.toMap(OffsetEncoding::getMagicByte, Function.identity()));
    }

    public static enum Version {
        v1,
        v2;

    }
}

