/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.parallelconsumer.internal.InternalRuntimeException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class JavaUtils {
    public static <T> Optional<T> getLast(List<T> commitHistory) {
        if (commitHistory.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(commitHistory.get(commitHistory.size() - 1));
    }

    public static <T> Optional<T> getOnlyOne(Map<String, T> stringMapMap) {
        if (stringMapMap.isEmpty()) {
            return Optional.empty();
        }
        Collection<T> values = stringMapMap.values();
        if (values.size() > 1) {
            throw new InternalRuntimeException("More than one element");
        }
        return Optional.of(values.iterator().next());
    }

    public static Duration max(Duration left, Duration right) {
        long expectedDurationOfClose = Math.max(left.toMillis(), right.toMillis());
        return Duration.ofMillis(expectedDurationOfClose);
    }

    public static boolean isGreaterThan(Duration compare, Duration to) {
        return compare.compareTo(to) > 0;
    }

    public static <K, V1, V2> Map<K, V2> remap(Map<K, V1> map, Function<? super V1, ? extends V2> function) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> function.apply((Object)e.getValue())));
    }

    private JavaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

