/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.parallelconsumer.RecordContext;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkContainer<K, V>
implements Comparable<WorkContainer<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(WorkContainer.class);
    static final String DEFAULT_TYPE = "DEFAULT";
    private final long epoch;
    private String workType;
    private final ConsumerRecord<K, V> cr;
    private final Clock clock;
    private int numberOfFailedAttempts = 0;
    private Optional<Instant> lastFailedAt = Optional.empty();
    private Optional<Instant> succeededAt = Optional.empty();
    private Optional<Throwable> lastFailureReason;
    private boolean inFlight = false;
    private Optional<Boolean> maybeUserFunctionSucceeded = Optional.empty();
    static Duration defaultRetryDelay = Duration.ofSeconds(1L);
    private Future<List<?>> future;
    private Optional<Long> timeTakenAsWorkMs = Optional.empty();
    private static Function<Object, Duration> retryDelayProvider;

    public WorkContainer(long epoch, ConsumerRecord<K, V> cr, Function<RecordContext<K, V>, Duration> retryDelayProvider, String workType, Clock clock) {
        Objects.requireNonNull(workType);
        this.epoch = epoch;
        this.cr = cr;
        this.workType = workType;
        this.clock = clock;
        if (WorkContainer.retryDelayProvider == null) {
            WorkContainer.retryDelayProvider = retryDelayProvider;
        }
    }

    public WorkContainer(long epoch, ConsumerRecord<K, V> cr, Function<RecordContext<K, V>, Duration> retryDelayProvider, Clock clock) {
        this(epoch, cr, retryDelayProvider, DEFAULT_TYPE, clock);
    }

    public void endFlight() {
        log.trace("Ending flight {}", (Object)this);
        this.inFlight = false;
    }

    public boolean hasDelayPassed() {
        if (!this.hasPreviouslyFailed()) {
            return true;
        }
        Duration delay = this.getDelayUntilRetryDue();
        boolean negative = delay.isNegative() || delay.isZero();
        return negative;
    }

    public Duration getDelayUntilRetryDue() {
        Instant now = this.clock.instant();
        Temporal nextAttemptAt = this.tryAgainAt();
        return Duration.between(now, nextAttemptAt);
    }

    private Temporal tryAgainAt() {
        if (this.lastFailedAt.isPresent()) {
            Duration retryDelay = this.getRetryDelayConfig();
            return this.lastFailedAt.get().plus(retryDelay);
        }
        return Instant.now();
    }

    public Duration getRetryDelayConfig() {
        if (retryDelayProvider != null) {
            return retryDelayProvider.apply(this);
        }
        return defaultRetryDelay;
    }

    @Override
    public int compareTo(WorkContainer o) {
        long myOffset = this.cr.offset();
        long theirOffset = o.cr.offset();
        int compare = Long.compare(myOffset, theirOffset);
        return compare;
    }

    public boolean isNotInFlight() {
        return !this.isInFlight();
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public void onQueueingForExecution() {
        log.trace("Queueing for execution: {}", (Object)this);
        this.inFlight = true;
        this.timeTakenAsWorkMs = Optional.of(System.currentTimeMillis());
    }

    public TopicPartition getTopicPartition() {
        return KafkaUtils.toTopicPartition(this.getCr());
    }

    public void onUserFunctionSuccess() {
        this.succeededAt = Optional.of(this.clock.instant());
        this.maybeUserFunctionSucceeded = Optional.of(true);
    }

    public void onUserFunctionFailure(Throwable cause) {
        log.trace("Failing {}", (Object)this);
        this.updateFailureHistory(cause);
        this.maybeUserFunctionSucceeded = Optional.of(false);
    }

    private void updateFailureHistory(Throwable cause) {
        ++this.numberOfFailedAttempts;
        this.lastFailedAt = Optional.of(Instant.now(this.clock));
        this.lastFailureReason = Optional.ofNullable(cause);
    }

    public boolean isUserFunctionComplete() {
        return this.getMaybeUserFunctionSucceeded().isPresent();
    }

    public boolean isUserFunctionSucceeded() {
        Optional<Boolean> userFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        return userFunctionSucceeded.orElse(false);
    }

    public String toString() {
        return "WorkContainer(" + KafkaUtils.toTopicPartition(this.cr) + ":" + this.cr.offset() + ":" + this.cr.key() + ")";
    }

    public Duration getTimeInFlight() {
        if (!this.timeTakenAsWorkMs.isPresent()) {
            return Duration.ZERO;
        }
        long millis = System.currentTimeMillis() - this.timeTakenAsWorkMs.get();
        return Duration.ofMillis(millis);
    }

    public long offset() {
        return this.getCr().offset();
    }

    public boolean hasPreviouslyFailed() {
        return this.getNumberOfFailedAttempts() > 0;
    }

    public boolean isAvailableToTakeAsWork() {
        return this.isNotInFlight() && !this.isUserFunctionSucceeded() && this.hasDelayPassed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkContainer)) {
            return false;
        }
        WorkContainer other = (WorkContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getNumberOfFailedAttempts() != other.getNumberOfFailedAttempts()) {
            return false;
        }
        if (this.isInFlight() != other.isInFlight()) {
            return false;
        }
        String this$workType = this.getWorkType();
        String other$workType = other.getWorkType();
        if (this$workType == null ? other$workType != null : !this$workType.equals(other$workType)) {
            return false;
        }
        ConsumerRecord<K, V> this$cr = this.getCr();
        ConsumerRecord<K, V> other$cr = other.getCr();
        if (this$cr == null ? other$cr != null : !this$cr.equals(other$cr)) {
            return false;
        }
        Clock this$clock = this.clock;
        Clock other$clock = other.clock;
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        Optional<Instant> this$lastFailedAt = this.getLastFailedAt();
        Optional<Instant> other$lastFailedAt = other.getLastFailedAt();
        if (this$lastFailedAt == null ? other$lastFailedAt != null : !((Object)this$lastFailedAt).equals(other$lastFailedAt)) {
            return false;
        }
        Optional<Instant> this$succeededAt = this.getSucceededAt();
        Optional<Instant> other$succeededAt = other.getSucceededAt();
        if (this$succeededAt == null ? other$succeededAt != null : !((Object)this$succeededAt).equals(other$succeededAt)) {
            return false;
        }
        Optional<Throwable> this$lastFailureReason = this.getLastFailureReason();
        Optional<Throwable> other$lastFailureReason = other.getLastFailureReason();
        if (this$lastFailureReason == null ? other$lastFailureReason != null : !((Object)this$lastFailureReason).equals(other$lastFailureReason)) {
            return false;
        }
        Optional<Boolean> this$maybeUserFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        Optional<Boolean> other$maybeUserFunctionSucceeded = other.getMaybeUserFunctionSucceeded();
        if (this$maybeUserFunctionSucceeded == null ? other$maybeUserFunctionSucceeded != null : !((Object)this$maybeUserFunctionSucceeded).equals(other$maybeUserFunctionSucceeded)) {
            return false;
        }
        Future<List<?>> this$future = this.getFuture();
        Future<List<?>> other$future = other.getFuture();
        if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
            return false;
        }
        Optional<Long> this$timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        Optional<Long> other$timeTakenAsWorkMs = other.timeTakenAsWorkMs;
        return !(this$timeTakenAsWorkMs == null ? other$timeTakenAsWorkMs != null : !((Object)this$timeTakenAsWorkMs).equals(other$timeTakenAsWorkMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        result = result * 59 + this.getNumberOfFailedAttempts();
        result = result * 59 + (this.isInFlight() ? 79 : 97);
        String $workType = this.getWorkType();
        result = result * 59 + ($workType == null ? 43 : $workType.hashCode());
        ConsumerRecord<K, V> $cr = this.getCr();
        result = result * 59 + ($cr == null ? 43 : $cr.hashCode());
        Clock $clock = this.clock;
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        Optional<Instant> $lastFailedAt = this.getLastFailedAt();
        result = result * 59 + ($lastFailedAt == null ? 43 : ((Object)$lastFailedAt).hashCode());
        Optional<Instant> $succeededAt = this.getSucceededAt();
        result = result * 59 + ($succeededAt == null ? 43 : ((Object)$succeededAt).hashCode());
        Optional<Throwable> $lastFailureReason = this.getLastFailureReason();
        result = result * 59 + ($lastFailureReason == null ? 43 : ((Object)$lastFailureReason).hashCode());
        Optional<Boolean> $maybeUserFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        result = result * 59 + ($maybeUserFunctionSucceeded == null ? 43 : ((Object)$maybeUserFunctionSucceeded).hashCode());
        Future<List<?>> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        Optional<Long> $timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        result = result * 59 + ($timeTakenAsWorkMs == null ? 43 : ((Object)$timeTakenAsWorkMs).hashCode());
        return result;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public String getWorkType() {
        return this.workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public ConsumerRecord<K, V> getCr() {
        return this.cr;
    }

    public int getNumberOfFailedAttempts() {
        return this.numberOfFailedAttempts;
    }

    public Optional<Instant> getLastFailedAt() {
        return this.lastFailedAt;
    }

    public Optional<Instant> getSucceededAt() {
        return this.succeededAt;
    }

    public Optional<Throwable> getLastFailureReason() {
        return this.lastFailureReason;
    }

    public Optional<Boolean> getMaybeUserFunctionSucceeded() {
        return this.maybeUserFunctionSucceeded;
    }

    public static void setDefaultRetryDelay(Duration defaultRetryDelay) {
        WorkContainer.defaultRetryDelay = defaultRetryDelay;
    }

    public Future<List<?>> getFuture() {
        return this.future;
    }

    public void setFuture(Future<List<?>> future) {
        this.future = future;
    }
}

