/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.internal.InternalRuntimeError;
import io.confluent.parallelconsumer.offsets.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitSetEncoder
extends OffsetEncoder {
    private static final Logger log = LoggerFactory.getLogger(BitSetEncoder.class);
    private final OffsetEncoding.Version version;
    private static final OffsetEncoding.Version DEFAULT_VERSION = OffsetEncoding.Version.v2;
    public static final Integer MAX_LENGTH_ENCODABLE = Integer.MAX_VALUE;
    private final BitSet bitSet;
    private final int originalLength;
    private Optional<byte[]> encodedBytes = Optional.empty();

    public BitSetEncoder(int length, OffsetSimultaneousEncoder offsetSimultaneousEncoder) throws BitSetEncodingNotSupportedException {
        this(length, offsetSimultaneousEncoder, DEFAULT_VERSION);
    }

    public BitSetEncoder(int length, OffsetSimultaneousEncoder offsetSimultaneousEncoder, OffsetEncoding.Version newVersion) throws BitSetEncodingNotSupportedException {
        super(offsetSimultaneousEncoder);
        this.version = newVersion;
        this.bitSet = new BitSet(length);
        this.originalLength = length;
    }

    private ByteBuffer constructWrappedByteBuffer(int length, OffsetEncoding.Version newVersion) throws BitSetEncodingNotSupportedException {
        ByteBuffer byteBuffer;
        switch (newVersion) {
            case v1: {
                byteBuffer = this.initV1(length);
                break;
            }
            case v2: {
                byteBuffer = this.initV2(length);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return byteBuffer;
    }

    private ByteBuffer initV2(int bitsetEntriesRequired) throws BitSetEncodingNotSupportedException {
        if (bitsetEntriesRequired > MAX_LENGTH_ENCODABLE) {
            throw new BitSetEncodingNotSupportedException(StringUtils.msg("BitSet V2 too long to encode, as length overflows Integer.MAX_VALUE. Length: {}. (max: {})", bitsetEntriesRequired, MAX_LENGTH_ENCODABLE));
        }
        int bytesRequiredForEntries = (int)Math.ceil((double)bitsetEntriesRequired / 8.0);
        int lengthEntryWidth = 4;
        int wrappedBufferLength = lengthEntryWidth + bytesRequiredForEntries + 1;
        ByteBuffer wrappedBitSetBytesBuffer = ByteBuffer.allocate(wrappedBufferLength);
        wrappedBitSetBytesBuffer.putInt(bitsetEntriesRequired);
        return wrappedBitSetBytesBuffer;
    }

    private ByteBuffer initV1(int bitsetEntriesRequired) throws BitSetEncodingNotSupportedException {
        if (bitsetEntriesRequired > Short.MAX_VALUE) {
            throw new BitSetEncodingNotSupportedException("Input too long to encode for BitSet V1, length overflows Short.MAX_VALUE: " + bitsetEntriesRequired + ". (max: " + Short.MAX_VALUE + ")");
        }
        int bytesRequiredForEntries = (int)Math.ceil((double)bitsetEntriesRequired / 8.0);
        int lengthEntryWidth = 2;
        int wrappedBufferLength = lengthEntryWidth + bytesRequiredForEntries + 1;
        ByteBuffer wrappedBitSetBytesBuffer = ByteBuffer.allocate(wrappedBufferLength);
        wrappedBitSetBytesBuffer.putShort((short)bitsetEntriesRequired);
        return wrappedBitSetBytesBuffer;
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            case v1: {
                offsetEncoding = OffsetEncoding.BitSet;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.BitSetV2;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return offsetEncoding;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            case v1: {
                offsetEncoding = OffsetEncoding.BitSetCompressed;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.BitSetV2Compressed;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return offsetEncoding;
    }

    @Override
    public void encodeIncompleteOffset(int index) {
    }

    @Override
    public void encodeCompletedOffset(int index) {
        this.bitSet.set(index);
    }

    @Override
    public byte[] serialise() throws BitSetEncodingNotSupportedException {
        byte[] bitSetArray = this.bitSet.toByteArray();
        ByteBuffer wrappedBitSetBytesBuffer = this.constructWrappedByteBuffer(this.originalLength, this.version);
        if (wrappedBitSetBytesBuffer.remaining() < bitSetArray.length) {
            throw new InternalRuntimeError("Not enough space in byte array");
        }
        try {
            wrappedBitSetBytesBuffer.put(bitSetArray);
        }
        catch (BufferOverflowException e) {
            throw new InternalRuntimeError("Error copying bitset into byte wrapper", e);
        }
        byte[] array = wrappedBitSetBytesBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }
}

