/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.state.PartitionStateManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

public final class EpochAndRecordsMap<K, V> {
    private final Map<TopicPartition, RecordsAndEpoch> recordMap = new HashMap<TopicPartition, RecordsAndEpoch>();

    public EpochAndRecordsMap(ConsumerRecords<K, V> poll, PartitionStateManager<K, V> pm) {
        poll.partitions().forEach(partition -> {
            List records = poll.records(partition);
            Long epochOfPartition = pm.getEpochOfPartition((TopicPartition)partition);
            this.recordMap.put((TopicPartition)partition, new RecordsAndEpoch(epochOfPartition, records));
        });
    }

    public Set<TopicPartition> partitions() {
        return Collections.unmodifiableSet(this.recordMap.keySet());
    }

    public RecordsAndEpoch records(TopicPartition partition) {
        return this.recordMap.get(partition);
    }

    public int count() {
        int count = 0;
        for (RecordsAndEpoch recs : this.recordMap.values()) {
            count += recs.getRecords().size();
        }
        return count;
    }

    public Map<TopicPartition, RecordsAndEpoch> getRecordMap() {
        return this.recordMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpochAndRecordsMap)) {
            return false;
        }
        EpochAndRecordsMap other = (EpochAndRecordsMap)o;
        Map<TopicPartition, RecordsAndEpoch> this$recordMap = this.getRecordMap();
        Map<TopicPartition, RecordsAndEpoch> other$recordMap = other.getRecordMap();
        return !(this$recordMap == null ? other$recordMap != null : !((Object)this$recordMap).equals(other$recordMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TopicPartition, RecordsAndEpoch> $recordMap = this.getRecordMap();
        result = result * 59 + ($recordMap == null ? 43 : ((Object)$recordMap).hashCode());
        return result;
    }

    public String toString() {
        return "EpochAndRecordsMap(recordMap=" + this.getRecordMap() + ")";
    }

    public final class RecordsAndEpoch {
        private final Long epochOfPartitionAtPoll;
        private final List<ConsumerRecord<K, V>> records;

        public RecordsAndEpoch(Long epochOfPartitionAtPoll, List<ConsumerRecord<K, V>> records) {
            this.epochOfPartitionAtPoll = epochOfPartitionAtPoll;
            this.records = records;
        }

        public Long getEpochOfPartitionAtPoll() {
            return this.epochOfPartitionAtPoll;
        }

        public List<ConsumerRecord<K, V>> getRecords() {
            return this.records;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordsAndEpoch)) {
                return false;
            }
            RecordsAndEpoch other = (RecordsAndEpoch)o;
            Long this$epochOfPartitionAtPoll = this.getEpochOfPartitionAtPoll();
            Long other$epochOfPartitionAtPoll = other.getEpochOfPartitionAtPoll();
            if (this$epochOfPartitionAtPoll == null ? other$epochOfPartitionAtPoll != null : !((Object)this$epochOfPartitionAtPoll).equals(other$epochOfPartitionAtPoll)) {
                return false;
            }
            List this$records = this.getRecords();
            List other$records = other.getRecords();
            return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $epochOfPartitionAtPoll = this.getEpochOfPartitionAtPoll();
            result = result * 59 + ($epochOfPartitionAtPoll == null ? 43 : ((Object)$epochOfPartitionAtPoll).hashCode());
            List $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            return result;
        }

        public String toString() {
            return "EpochAndRecordsMap.RecordsAndEpoch(epochOfPartitionAtPoll=" + this.getEpochOfPartitionAtPoll() + ", records=" + this.getRecords() + ")";
        }
    }
}

