/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.internal.ConsumerManager;
import io.confluent.parallelconsumer.internal.OffsetCommitter;
import io.confluent.parallelconsumer.state.WorkManager;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOffsetCommitter<K, V>
implements OffsetCommitter {
    private static final Logger log = LoggerFactory.getLogger(AbstractOffsetCommitter.class);
    protected final ConsumerManager<K, V> consumerMgr;
    protected final WorkManager<K, V> wm;

    @Override
    public void retrieveOffsetsAndCommit() {
        log.debug("Commit starting - find completed work to commit offsets");
        this.preAcquireWork();
        try {
            Map<TopicPartition, OffsetAndMetadata> offsetsToCommit = this.wm.collectCommitDataForDirtyPartitions();
            if (offsetsToCommit.isEmpty()) {
                log.debug("No offsets ready");
            } else {
                log.debug("Will commit offsets for {} partition(s): {}", (Object)offsetsToCommit.size(), offsetsToCommit);
                ConsumerGroupMetadata groupMetadata = this.consumerMgr.groupMetadata();
                log.debug("Begin commit");
                this.commitOffsets(offsetsToCommit, groupMetadata);
                log.debug("On commit success");
                this.onOffsetCommitSuccess(offsetsToCommit);
            }
        }
        finally {
            this.postCommit();
        }
    }

    protected void postCommit() {
    }

    protected void preAcquireWork() {
    }

    private void onOffsetCommitSuccess(Map<TopicPartition, OffsetAndMetadata> committed) {
        this.wm.onOffsetCommitSuccess(committed);
    }

    protected abstract void commitOffsets(Map<TopicPartition, OffsetAndMetadata> var1, ConsumerGroupMetadata var2);

    public AbstractOffsetCommitter(ConsumerManager<K, V> consumerMgr, WorkManager<K, V> wm) {
        this.consumerMgr = consumerMgr;
        this.wm = wm;
    }
}

