/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.ErrorInUserFunctionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class UserFunctions {
    public static final String MSG = "Error occurred in code supplied by user";

    public static <T, U, R> R carefullyRun(BiFunction<T, U, R> wrappedFunction, T t, U u) {
        try {
            return wrappedFunction.apply(t, u);
        }
        catch (Exception e) {
            throw new ErrorInUserFunctionException(MSG, e);
        }
    }

    public static <A, B> B carefullyRun(Function<A, B> wrappedFunction, A a) {
        try {
            return wrappedFunction.apply(a);
        }
        catch (Exception e) {
            throw new ErrorInUserFunctionException(MSG, e);
        }
    }

    public static <A> void carefullyRun(Consumer<A> wrappedFunction, A a) {
        try {
            wrappedFunction.accept(a);
        }
        catch (Exception e) {
            throw new ErrorInUserFunctionException(MSG, e);
        }
    }

    private UserFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

