/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class PartitionState<K, V> {
    private final TopicPartition tp;
    private Set<Long> incompleteOffsets;
    @NonNull
    private Long offsetHighestSeen;
    private boolean allowedMoreRecords = true;
    private final NavigableMap<Long, WorkContainer<K, V>> commitQueues = new ConcurrentSkipListMap<Long, WorkContainer<K, V>>();

    public PartitionState(TopicPartition tp, OffsetMapCodecManager.HighestOffsetAndIncompletes incompletes) {
        this.tp = tp;
        this.incompleteOffsets = incompletes.getIncompleteOffsets();
        this.offsetHighestSeen = incompletes.getHighestSeenOffset();
    }

    public void maybeRaiseHighestSeenOffset(long highestSeen) {
        Long oldHighestSeen = this.offsetHighestSeen;
        if (oldHighestSeen == null || highestSeen >= oldHighestSeen) {
            this.offsetHighestSeen = highestSeen;
        }
    }

    public void truncateOffsets(long newLowWaterMark) {
        this.incompleteOffsets.removeIf(offset -> offset < newLowWaterMark);
    }

    public void onOffsetCommitSuccess(OffsetAndMetadata meta) {
        long newLowWaterMark = meta.offset();
        this.truncateOffsets(newLowWaterMark);
    }

    public boolean isRecordPreviouslyProcessed(ConsumerRecord<K, V> rec) {
        Long offsetHighWaterMark;
        Set<Long> incompleteOffsets = this.incompleteOffsets;
        long offset = rec.offset();
        boolean previouslyProcessed = incompleteOffsets.contains(offset) ? false : (offsetHighWaterMark = this.offsetHighestSeen) != null && offset <= offsetHighWaterMark;
        return previouslyProcessed;
    }

    public boolean hasWorkInCommitQueue() {
        return !this.commitQueues.isEmpty();
    }

    public int getCommitQueueSize() {
        return this.commitQueues.size();
    }

    public TopicPartition getTp() {
        return this.tp;
    }

    public Set<Long> getIncompleteOffsets() {
        return this.incompleteOffsets;
    }

    public void setIncompleteOffsets(Set<Long> incompleteOffsets) {
        this.incompleteOffsets = incompleteOffsets;
    }

    @NonNull
    public Long getOffsetHighestSeen() {
        return this.offsetHighestSeen;
    }

    boolean isAllowedMoreRecords() {
        return this.allowedMoreRecords;
    }

    void setAllowedMoreRecords(boolean allowedMoreRecords) {
        this.allowedMoreRecords = allowedMoreRecords;
    }

    NavigableMap<Long, WorkContainer<K, V>> getCommitQueues() {
        return this.commitQueues;
    }
}

