/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class ParallelConsumerOptions<K, V> {
    private final Consumer<K, V> consumer;
    private final Producer<K, V> producer;
    private final ProcessingOrder ordering;
    private final CommitMode commitMode;
    private final int maxConcurrency;
    private final Duration defaultMessageRetryDelay;

    public void validate() {
        Objects.requireNonNull(this.consumer, "A consumer must be supplied");
        if (this.isUsingTransactionalProducer() && this.producer == null) {
            throw new IllegalArgumentException(StringUtils.msg("Wanting to use Transaction Producer mode ({}) without supplying a Producer instance", new Object[]{this.commitMode}));
        }
        WorkContainer.setDefaultRetryDelay(this.getDefaultMessageRetryDelay());
    }

    public boolean isUsingTransactionalProducer() {
        return this.commitMode.equals((Object)CommitMode.PERIODIC_TRANSACTIONAL_PRODUCER);
    }

    public boolean isProducerSupplied() {
        return this.getProducer() != null;
    }

    private static <K, V> ProcessingOrder $default$ordering() {
        return ProcessingOrder.KEY;
    }

    private static <K, V> CommitMode $default$commitMode() {
        return CommitMode.PERIODIC_CONSUMER_ASYNCHRONOUS;
    }

    private static <K, V> int $default$maxConcurrency() {
        return 16;
    }

    private static <K, V> Duration $default$defaultMessageRetryDelay() {
        return Duration.ofSeconds(1L);
    }

    ParallelConsumerOptions(Consumer<K, V> consumer, Producer<K, V> producer, ProcessingOrder ordering, CommitMode commitMode, int maxConcurrency, Duration defaultMessageRetryDelay) {
        this.consumer = consumer;
        this.producer = producer;
        this.ordering = ordering;
        this.commitMode = commitMode;
        this.maxConcurrency = maxConcurrency;
        this.defaultMessageRetryDelay = defaultMessageRetryDelay;
    }

    public static <K, V> ParallelConsumerOptionsBuilder<K, V> builder() {
        return new ParallelConsumerOptionsBuilder();
    }

    public ParallelConsumerOptionsBuilder<K, V> toBuilder() {
        return new ParallelConsumerOptionsBuilder<K, V>().consumer(this.consumer).producer(this.producer).ordering(this.ordering).commitMode(this.commitMode).maxConcurrency(this.maxConcurrency).defaultMessageRetryDelay(this.defaultMessageRetryDelay);
    }

    public Consumer<K, V> getConsumer() {
        return this.consumer;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public ProcessingOrder getOrdering() {
        return this.ordering;
    }

    public CommitMode getCommitMode() {
        return this.commitMode;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public Duration getDefaultMessageRetryDelay() {
        return this.defaultMessageRetryDelay;
    }

    public String toString() {
        return "ParallelConsumerOptions(consumer=" + this.getConsumer() + ", producer=" + this.getProducer() + ", ordering=" + (Object)((Object)this.getOrdering()) + ", commitMode=" + (Object)((Object)this.getCommitMode()) + ", maxConcurrency=" + this.getMaxConcurrency() + ", defaultMessageRetryDelay=" + this.getDefaultMessageRetryDelay() + ")";
    }

    public static enum CommitMode {
        PERIODIC_TRANSACTIONAL_PRODUCER,
        PERIODIC_CONSUMER_SYNC,
        PERIODIC_CONSUMER_ASYNCHRONOUS;

    }

    public static enum ProcessingOrder {
        UNORDERED,
        PARTITION,
        KEY;

    }

    public static class ParallelConsumerOptionsBuilder<K, V> {
        private Consumer<K, V> consumer;
        private Producer<K, V> producer;
        private boolean ordering$set;
        private ProcessingOrder ordering$value;
        private boolean commitMode$set;
        private CommitMode commitMode$value;
        private boolean maxConcurrency$set;
        private int maxConcurrency$value;
        private boolean defaultMessageRetryDelay$set;
        private Duration defaultMessageRetryDelay$value;

        ParallelConsumerOptionsBuilder() {
        }

        public ParallelConsumerOptionsBuilder<K, V> consumer(Consumer<K, V> consumer) {
            this.consumer = consumer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> producer(Producer<K, V> producer) {
            this.producer = producer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> ordering(ProcessingOrder ordering) {
            this.ordering$value = ordering;
            this.ordering$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> commitMode(CommitMode commitMode) {
            this.commitMode$value = commitMode;
            this.commitMode$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> maxConcurrency(int maxConcurrency) {
            this.maxConcurrency$value = maxConcurrency;
            this.maxConcurrency$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> defaultMessageRetryDelay(Duration defaultMessageRetryDelay) {
            this.defaultMessageRetryDelay$value = defaultMessageRetryDelay;
            this.defaultMessageRetryDelay$set = true;
            return this;
        }

        public ParallelConsumerOptions<K, V> build() {
            ProcessingOrder ordering$value = this.ordering$value;
            if (!this.ordering$set) {
                ordering$value = ParallelConsumerOptions.$default$ordering();
            }
            CommitMode commitMode$value = this.commitMode$value;
            if (!this.commitMode$set) {
                commitMode$value = ParallelConsumerOptions.$default$commitMode();
            }
            int maxConcurrency$value = this.maxConcurrency$value;
            if (!this.maxConcurrency$set) {
                maxConcurrency$value = ParallelConsumerOptions.$default$maxConcurrency();
            }
            Duration defaultMessageRetryDelay$value = this.defaultMessageRetryDelay$value;
            if (!this.defaultMessageRetryDelay$set) {
                defaultMessageRetryDelay$value = ParallelConsumerOptions.$default$defaultMessageRetryDelay();
            }
            return new ParallelConsumerOptions<K, V>(this.consumer, this.producer, ordering$value, commitMode$value, maxConcurrency$value, defaultMessageRetryDelay$value);
        }

        public String toString() {
            return "ParallelConsumerOptions.ParallelConsumerOptionsBuilder(consumer=" + this.consumer + ", producer=" + this.producer + ", ordering$value=" + (Object)((Object)this.ordering$value) + ", commitMode$value=" + (Object)((Object)this.commitMode$value) + ", maxConcurrency$value=" + this.maxConcurrency$value + ", defaultMessageRetryDelay$value=" + this.defaultMessageRetryDelay$value + ")";
        }
    }
}

