/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.csid.utils.WallClock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkContainer<K, V>
implements Comparable<WorkContainer> {
    private static final Logger log = LoggerFactory.getLogger(WorkContainer.class);
    private final String DEFAULT_TYPE = "DEFAULT";
    private final int epoch;
    private String workType;
    private final ConsumerRecord<K, V> cr;
    private int numberOfFailedAttempts;
    private Optional<Instant> failedAt = Optional.empty();
    private boolean inFlight = false;
    private Optional<Boolean> userFunctionSucceeded = Optional.empty();
    private Duration retryDelay;
    static Duration defaultRetryDelay = Duration.ofSeconds(1L);
    private Future<List<Object>> future;
    private Optional<Long> timeTakenAsWorkMs = Optional.empty();

    public WorkContainer(int epoch, ConsumerRecord<K, V> cr) {
        this.epoch = epoch;
        this.cr = cr;
        this.workType = "DEFAULT";
    }

    public WorkContainer(int epoch, ConsumerRecord<K, V> cr, String workType) {
        this.epoch = epoch;
        this.cr = cr;
        Objects.requireNonNull(workType);
        this.workType = workType;
    }

    public void fail(WallClock clock) {
        log.trace("Failing {}", (Object)this);
        ++this.numberOfFailedAttempts;
        this.failedAt = Optional.of(clock.getNow());
        this.inFlight = false;
    }

    public void succeed() {
        log.trace("Succeeded {}", (Object)this);
        this.inFlight = false;
    }

    public boolean hasDelayPassed(WallClock clock) {
        if (!this.hasPreviouslyFailed()) {
            return true;
        }
        Duration delay = this.getDelay(clock);
        boolean negative = delay.isNegative() || delay.isZero();
        return negative;
    }

    public Duration getDelay(WallClock clock) {
        Instant now = clock.getNow();
        Temporal nextAttemptAt = this.tryAgainAt(clock);
        return Duration.between(now, nextAttemptAt);
    }

    private Temporal tryAgainAt(WallClock clock) {
        if (this.failedAt.isPresent()) {
            Duration retryDelay = this.getRetryDelay();
            return this.failedAt.get().plus(retryDelay);
        }
        return Instant.MIN;
    }

    public Duration getRetryDelay() {
        if (this.retryDelay == null) {
            return defaultRetryDelay;
        }
        return this.retryDelay;
    }

    @Override
    public int compareTo(WorkContainer o) {
        long myOffset = this.cr.offset();
        long theirOffset = o.cr.offset();
        int compare = Long.compare(myOffset, theirOffset);
        return compare;
    }

    public boolean isNotInFlight() {
        return !this.inFlight;
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public void queueingForExecution() {
        log.trace("Queueing for execution: {}", (Object)this);
        this.inFlight = true;
        this.timeTakenAsWorkMs = Optional.of(System.currentTimeMillis());
    }

    public TopicPartition getTopicPartition() {
        return KafkaUtils.toTP(this.getCr());
    }

    public void onUserFunctionSuccess() {
        this.userFunctionSucceeded = Optional.of(true);
    }

    public void onUserFunctionFailure() {
        this.userFunctionSucceeded = Optional.of(false);
    }

    public boolean isUserFunctionComplete() {
        return this.getUserFunctionSucceeded().isPresent();
    }

    public boolean isUserFunctionSucceeded() {
        Optional<Boolean> userFunctionSucceeded = this.getUserFunctionSucceeded();
        return userFunctionSucceeded.orElse(false);
    }

    public String toString() {
        return "WorkContainer(" + KafkaUtils.toTP(this.cr) + ":" + this.cr.offset() + ":" + this.cr.key() + ")";
    }

    public Duration getTimeInFlight() {
        if (!this.timeTakenAsWorkMs.isPresent()) {
            return Duration.ZERO;
        }
        long millis = System.currentTimeMillis() - this.timeTakenAsWorkMs.get();
        return Duration.ofMillis(millis);
    }

    public long offset() {
        return this.getCr().offset();
    }

    public boolean hasPreviouslyFailed() {
        return this.getNumberOfFailedAttempts() > 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkContainer)) {
            return false;
        }
        WorkContainer other = (WorkContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getNumberOfFailedAttempts() != other.getNumberOfFailedAttempts()) {
            return false;
        }
        if (this.isInFlight() != other.isInFlight()) {
            return false;
        }
        String this$DEFAULT_TYPE = this.DEFAULT_TYPE;
        String other$DEFAULT_TYPE = other.DEFAULT_TYPE;
        if (this$DEFAULT_TYPE == null ? other$DEFAULT_TYPE != null : !this$DEFAULT_TYPE.equals(other$DEFAULT_TYPE)) {
            return false;
        }
        String this$workType = this.getWorkType();
        String other$workType = other.getWorkType();
        if (this$workType == null ? other$workType != null : !this$workType.equals(other$workType)) {
            return false;
        }
        ConsumerRecord<K, V> this$cr = this.getCr();
        ConsumerRecord<K, V> other$cr = other.getCr();
        if (this$cr == null ? other$cr != null : !this$cr.equals(other$cr)) {
            return false;
        }
        Optional<Instant> this$failedAt = this.failedAt;
        Optional<Instant> other$failedAt = other.failedAt;
        if (this$failedAt == null ? other$failedAt != null : !((Object)this$failedAt).equals(other$failedAt)) {
            return false;
        }
        Optional<Boolean> this$userFunctionSucceeded = this.getUserFunctionSucceeded();
        Optional<Boolean> other$userFunctionSucceeded = other.getUserFunctionSucceeded();
        if (this$userFunctionSucceeded == null ? other$userFunctionSucceeded != null : !((Object)this$userFunctionSucceeded).equals(other$userFunctionSucceeded)) {
            return false;
        }
        Duration this$retryDelay = this.getRetryDelay();
        Duration other$retryDelay = other.getRetryDelay();
        if (this$retryDelay == null ? other$retryDelay != null : !((Object)this$retryDelay).equals(other$retryDelay)) {
            return false;
        }
        Future<List<Object>> this$future = this.getFuture();
        Future<List<Object>> other$future = other.getFuture();
        if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
            return false;
        }
        Optional<Long> this$timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        Optional<Long> other$timeTakenAsWorkMs = other.timeTakenAsWorkMs;
        return !(this$timeTakenAsWorkMs == null ? other$timeTakenAsWorkMs != null : !((Object)this$timeTakenAsWorkMs).equals(other$timeTakenAsWorkMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpoch();
        result = result * 59 + this.getNumberOfFailedAttempts();
        result = result * 59 + (this.isInFlight() ? 79 : 97);
        String $DEFAULT_TYPE = this.DEFAULT_TYPE;
        result = result * 59 + ($DEFAULT_TYPE == null ? 43 : $DEFAULT_TYPE.hashCode());
        String $workType = this.getWorkType();
        result = result * 59 + ($workType == null ? 43 : $workType.hashCode());
        ConsumerRecord<K, V> $cr = this.getCr();
        result = result * 59 + ($cr == null ? 43 : $cr.hashCode());
        Optional<Instant> $failedAt = this.failedAt;
        result = result * 59 + ($failedAt == null ? 43 : ((Object)$failedAt).hashCode());
        Optional<Boolean> $userFunctionSucceeded = this.getUserFunctionSucceeded();
        result = result * 59 + ($userFunctionSucceeded == null ? 43 : ((Object)$userFunctionSucceeded).hashCode());
        Duration $retryDelay = this.getRetryDelay();
        result = result * 59 + ($retryDelay == null ? 43 : ((Object)$retryDelay).hashCode());
        Future<List<Object>> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        Optional<Long> $timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        result = result * 59 + ($timeTakenAsWorkMs == null ? 43 : ((Object)$timeTakenAsWorkMs).hashCode());
        return result;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public String getWorkType() {
        return this.workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public ConsumerRecord<K, V> getCr() {
        return this.cr;
    }

    public int getNumberOfFailedAttempts() {
        return this.numberOfFailedAttempts;
    }

    public Optional<Boolean> getUserFunctionSucceeded() {
        return this.userFunctionSucceeded;
    }

    public static void setDefaultRetryDelay(Duration defaultRetryDelay) {
        WorkContainer.defaultRetryDelay = defaultRetryDelay;
    }

    public Future<List<Object>> getFuture() {
        return this.future;
    }

    public void setFuture(Future<List<Object>> future) {
        this.future = future;
    }
}

