/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import java.io.Closeable;
import java.time.Duration;

public interface DrainingCloseable
extends Closeable {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);

    @Override
    default public void close() {
        this.closeDontDrainFirst();
    }

    default public void closeDrainFirst() {
        this.closeDrainFirst(DEFAULT_TIMEOUT);
    }

    default public void closeDontDrainFirst() {
        this.closeDontDrainFirst(DEFAULT_TIMEOUT);
    }

    default public void closeDrainFirst(Duration timeout) {
        this.close(timeout, DrainingMode.DRAIN);
    }

    default public void closeDontDrainFirst(Duration timeout) {
        this.close(timeout, DrainingMode.DONT_DRAIN);
    }

    public void close(Duration var1, DrainingMode var2);

    public int workRemaining();

    public static enum DrainingMode {
        DRAIN,
        DONT_DRAIN;

    }
}

