/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

enum OffsetEncoding {
    ByteArray(76),
    ByteArrayCompressed(-18),
    BitSet(108),
    BitSetCompressed(97),
    RunLength(110),
    RunLengthCompressed(74);

    public final byte magicByte;
    private static final Map<Byte, OffsetEncoding> magicMap;

    public static OffsetEncoding decode(byte magic) {
        OffsetEncoding encoding = magicMap.get(magic);
        if (encoding == null) {
            throw new RuntimeException("Unexpected magic: " + magic);
        }
        return encoding;
    }

    public String toString() {
        return "OffsetEncoding." + this.name() + "(magicByte=" + this.getMagicByte() + ")";
    }

    private OffsetEncoding(byte magicByte) {
        this.magicByte = magicByte;
    }

    public byte getMagicByte() {
        return this.magicByte;
    }

    static {
        magicMap = Arrays.stream(OffsetEncoding.values()).collect(Collectors.toMap(OffsetEncoding::getMagicByte, Function.identity()));
    }
}

