/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.OffsetBitSet;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.OffsetRunLength;
import io.confluent.parallelconsumer.OffsetSimpleSerialisation;
import io.confluent.parallelconsumer.ParallelConsumer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EncodedOffsetPair
implements Comparable<EncodedOffsetPair> {
    private static final Logger log = LoggerFactory.getLogger(EncodedOffsetPair.class);
    OffsetEncoding encoding;
    ByteBuffer data;

    EncodedOffsetPair(OffsetEncoding encoding, ByteBuffer data) {
        this.encoding = encoding;
        this.data = data;
    }

    @Override
    public int compareTo(EncodedOffsetPair o) {
        return Integer.compare(this.data.capacity(), o.getData().capacity());
    }

    public String toString() {
        return "\n{" + this.encoding.name() + ", \t\t\tsize=" + this.data.capacity() + "}";
    }

    public byte[] readDataArrayForDebug() {
        return EncodedOffsetPair.copyBytesOutOfBufferForDebug(this.data);
    }

    private static byte[] copyBytesOutOfBufferForDebug(ByteBuffer bbData) {
        bbData.position(0);
        byte[] bytes = new byte[bbData.remaining()];
        bbData.get(bytes, 0, bbData.limit());
        return bytes;
    }

    static EncodedOffsetPair unwrap(byte[] input) {
        ByteBuffer wrap = ByteBuffer.wrap(input).asReadOnlyBuffer();
        byte magic = wrap.get();
        OffsetEncoding decode = OffsetEncoding.decode(magic);
        ByteBuffer slice = wrap.slice();
        return new EncodedOffsetPair(decode, slice);
    }

    public String getDecodedString() {
        String string;
        switch (this.encoding) {
            case ByteArray: {
                string = OffsetSimpleSerialisation.deserialiseByteArrayToBitMapString(this.data);
                break;
            }
            case ByteArrayCompressed: {
                string = OffsetSimpleSerialisation.deserialiseByteArrayToBitMapString(OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case BitSet: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data);
                break;
            }
            case BitSetCompressed: {
                string = OffsetBitSet.deserialiseBitSetWrap(OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case RunLength: {
                string = OffsetRunLength.runLengthDecodeToString(OffsetRunLength.runLengthDeserialise(this.data));
                break;
            }
            case RunLengthCompressed: {
                string = OffsetRunLength.runLengthDecodeToString(OffsetRunLength.runLengthDeserialise(OffsetSimpleSerialisation.decompressZstd(this.data)));
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        String binaryArrayString = string;
        return binaryArrayString;
    }

    public ParallelConsumer.Tuple<Long, Set<Long>> getDecodedIncompletes(long baseOffset) {
        ParallelConsumer.Tuple<Long, Set<Long>> tuple;
        switch (this.encoding) {
            case BitSet: {
                tuple = OffsetBitSet.deserialiseBitSetWrapToIncompletes(baseOffset, this.data);
                break;
            }
            case BitSetCompressed: {
                tuple = OffsetBitSet.deserialiseBitSetWrapToIncompletes(baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case RunLength: {
                tuple = OffsetRunLength.runLengthDecodeToIncompletes(baseOffset, this.data);
                break;
            }
            case RunLengthCompressed: {
                tuple = OffsetRunLength.runLengthDecodeToIncompletes(baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Encoding (" + this.encoding.name() + ") not supported");
            }
        }
        ParallelConsumer.Tuple<Long, Set<Long>> binaryArrayString = tuple;
        return binaryArrayString;
    }

    public OffsetEncoding getEncoding() {
        return this.encoding;
    }

    public ByteBuffer getData() {
        return this.data;
    }
}

