/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.csid.utils.WallClock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkContainer<K, V>
implements Comparable<WorkContainer> {
    private static final Logger log = LoggerFactory.getLogger(WorkContainer.class);
    private final String DEFAULT_TYPE = "DEFAULT";
    private String workType;
    private final ConsumerRecord<K, V> cr;
    private int numberOfAttempts;
    private Optional<Instant> failedAt = Optional.empty();
    private boolean inFlight = false;
    private Optional<Boolean> userFunctionSucceeded = Optional.empty();
    private static Duration retryDelay = Duration.ofSeconds(10L);
    private Future<List<Object>> future;

    public WorkContainer(ConsumerRecord<K, V> cr) {
        this.cr = cr;
        this.workType = "DEFAULT";
    }

    public WorkContainer(ConsumerRecord<K, V> cr, String workType) {
        this.cr = cr;
        Objects.requireNonNull(workType);
        this.workType = workType;
    }

    public void fail(WallClock clock) {
        log.trace("Failing {}", (Object)this);
        ++this.numberOfAttempts;
        this.failedAt = Optional.of(clock.getNow());
        this.inFlight = false;
    }

    public void succeed() {
        log.trace("Succeeded {}", (Object)this);
        this.inFlight = false;
    }

    public boolean hasDelayPassed(WallClock clock) {
        long delay = this.getDelay(TimeUnit.SECONDS, clock);
        boolean delayHasPassed = delay <= 0L;
        return delayHasPassed;
    }

    public long getDelay(TimeUnit unit, WallClock clock) {
        Instant now = clock.getNow();
        Duration between = Duration.between(now, this.tryAgainAt(clock));
        long convert = unit.convert(between.toMillis(), TimeUnit.MILLISECONDS);
        return convert;
    }

    private Temporal tryAgainAt(WallClock clock) {
        if (this.failedAt.isPresent()) {
            return this.failedAt.get().plus(retryDelay);
        }
        return clock.getNow();
    }

    @Override
    public int compareTo(WorkContainer o) {
        long myOffset = this.cr.offset();
        long theirOffset = o.cr.offset();
        int compare = Long.compare(myOffset, theirOffset);
        return compare;
    }

    public boolean isNotInFlight() {
        return !this.inFlight;
    }

    public void takingAsWork() {
        log.trace("Being taken as work: {}", (Object)this);
        this.inFlight = true;
    }

    public TopicPartition getTopicPartition() {
        return KafkaUtils.toTP(this.getCr());
    }

    public void onUserFunctionSuccess() {
        this.userFunctionSucceeded = Optional.of(true);
    }

    public void onUserFunctionFailure() {
        this.userFunctionSucceeded = Optional.of(false);
    }

    public boolean isUserFunctionComplete() {
        return this.getUserFunctionSucceeded().isPresent();
    }

    public boolean isUserFunctionSucceeded() {
        Optional<Boolean> userFunctionSucceeded = this.getUserFunctionSucceeded();
        return userFunctionSucceeded.orElse(false);
    }

    public String toString() {
        return "WorkContainer(" + KafkaUtils.toTP(this.cr) + ":" + this.cr.offset() + ":" + this.cr.key() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkContainer)) {
            return false;
        }
        WorkContainer other = (WorkContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.numberOfAttempts != other.numberOfAttempts) {
            return false;
        }
        if (this.inFlight != other.inFlight) {
            return false;
        }
        String this$DEFAULT_TYPE = this.DEFAULT_TYPE;
        String other$DEFAULT_TYPE = other.DEFAULT_TYPE;
        if (this$DEFAULT_TYPE == null ? other$DEFAULT_TYPE != null : !this$DEFAULT_TYPE.equals(other$DEFAULT_TYPE)) {
            return false;
        }
        String this$workType = this.getWorkType();
        String other$workType = other.getWorkType();
        if (this$workType == null ? other$workType != null : !this$workType.equals(other$workType)) {
            return false;
        }
        ConsumerRecord<K, V> this$cr = this.getCr();
        ConsumerRecord<K, V> other$cr = other.getCr();
        if (this$cr == null ? other$cr != null : !this$cr.equals(other$cr)) {
            return false;
        }
        Optional<Instant> this$failedAt = this.failedAt;
        Optional<Instant> other$failedAt = other.failedAt;
        if (this$failedAt == null ? other$failedAt != null : !((Object)this$failedAt).equals(other$failedAt)) {
            return false;
        }
        Optional<Boolean> this$userFunctionSucceeded = this.getUserFunctionSucceeded();
        Optional<Boolean> other$userFunctionSucceeded = other.getUserFunctionSucceeded();
        if (this$userFunctionSucceeded == null ? other$userFunctionSucceeded != null : !((Object)this$userFunctionSucceeded).equals(other$userFunctionSucceeded)) {
            return false;
        }
        Future<List<Object>> this$future = this.getFuture();
        Future<List<Object>> other$future = other.getFuture();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.numberOfAttempts;
        result = result * 59 + (this.inFlight ? 79 : 97);
        String $DEFAULT_TYPE = this.DEFAULT_TYPE;
        result = result * 59 + ($DEFAULT_TYPE == null ? 43 : $DEFAULT_TYPE.hashCode());
        String $workType = this.getWorkType();
        result = result * 59 + ($workType == null ? 43 : $workType.hashCode());
        ConsumerRecord<K, V> $cr = this.getCr();
        result = result * 59 + ($cr == null ? 43 : $cr.hashCode());
        Optional<Instant> $failedAt = this.failedAt;
        result = result * 59 + ($failedAt == null ? 43 : ((Object)$failedAt).hashCode());
        Optional<Boolean> $userFunctionSucceeded = this.getUserFunctionSucceeded();
        result = result * 59 + ($userFunctionSucceeded == null ? 43 : ((Object)$userFunctionSucceeded).hashCode());
        Future<List<Object>> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        return result;
    }

    public String getWorkType() {
        return this.workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public ConsumerRecord<K, V> getCr() {
        return this.cr;
    }

    public Optional<Boolean> getUserFunctionSucceeded() {
        return this.userFunctionSucceeded;
    }

    public static Duration getRetryDelay() {
        return retryDelay;
    }

    public Future<List<Object>> getFuture() {
        return this.future;
    }

    void setFuture(Future<List<Object>> future) {
        this.future = future;
    }
}

