/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import java.util.Objects;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class ParallelConsumerOptions<K, V> {
    private final Consumer<K, V> consumer;
    private final Producer<K, V> producer;
    private final ProcessingOrder ordering;
    private final CommitMode commitMode;
    private final int maxNumberMessagesBeyondBaseCommitOffset;
    private final int maxMessagesToQueue;
    private final int numberOfThreads;

    public void validate() {
        Objects.requireNonNull(this.consumer, "A consumer must be supplied");
        if (this.isUsingTransactionalProducer() && this.producer == null) {
            throw new IllegalArgumentException(StringUtils.msg("Wanting to use Transaction Producer mode ({}) without supplying a Producer instance", new Object[]{this.commitMode}));
        }
    }

    protected boolean isUsingTransactionalProducer() {
        return this.commitMode.equals((Object)CommitMode.TRANSACTIONAL_PRODUCER);
    }

    public boolean isProducerSupplied() {
        return this.getProducer() != null;
    }

    private static <K, V> ProcessingOrder $default$ordering() {
        return ProcessingOrder.UNORDERED;
    }

    private static <K, V> CommitMode $default$commitMode() {
        return CommitMode.CONSUMER_ASYNCHRONOUS;
    }

    private static <K, V> int $default$maxNumberMessagesBeyondBaseCommitOffset() {
        return 1000;
    }

    private static <K, V> int $default$maxMessagesToQueue() {
        return 100;
    }

    private static <K, V> int $default$numberOfThreads() {
        return 16;
    }

    ParallelConsumerOptions(Consumer<K, V> consumer, Producer<K, V> producer, ProcessingOrder ordering, CommitMode commitMode, int maxNumberMessagesBeyondBaseCommitOffset, int maxMessagesToQueue, int numberOfThreads) {
        this.consumer = consumer;
        this.producer = producer;
        this.ordering = ordering;
        this.commitMode = commitMode;
        this.maxNumberMessagesBeyondBaseCommitOffset = maxNumberMessagesBeyondBaseCommitOffset;
        this.maxMessagesToQueue = maxMessagesToQueue;
        this.numberOfThreads = numberOfThreads;
    }

    public static <K, V> ParallelConsumerOptionsBuilder<K, V> builder() {
        return new ParallelConsumerOptionsBuilder();
    }

    public ParallelConsumerOptionsBuilder<K, V> toBuilder() {
        return new ParallelConsumerOptionsBuilder<K, V>().consumer(this.consumer).producer(this.producer).ordering(this.ordering).commitMode(this.commitMode).maxNumberMessagesBeyondBaseCommitOffset(this.maxNumberMessagesBeyondBaseCommitOffset).maxMessagesToQueue(this.maxMessagesToQueue).numberOfThreads(this.numberOfThreads);
    }

    public Consumer<K, V> getConsumer() {
        return this.consumer;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public ProcessingOrder getOrdering() {
        return this.ordering;
    }

    public CommitMode getCommitMode() {
        return this.commitMode;
    }

    public int getMaxNumberMessagesBeyondBaseCommitOffset() {
        return this.maxNumberMessagesBeyondBaseCommitOffset;
    }

    public int getMaxMessagesToQueue() {
        return this.maxMessagesToQueue;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public String toString() {
        return "ParallelConsumerOptions(consumer=" + this.getConsumer() + ", producer=" + this.getProducer() + ", ordering=" + (Object)((Object)this.getOrdering()) + ", commitMode=" + (Object)((Object)this.getCommitMode()) + ", maxNumberMessagesBeyondBaseCommitOffset=" + this.getMaxNumberMessagesBeyondBaseCommitOffset() + ", maxMessagesToQueue=" + this.getMaxMessagesToQueue() + ", numberOfThreads=" + this.getNumberOfThreads() + ")";
    }

    public static enum CommitMode {
        TRANSACTIONAL_PRODUCER,
        CONSUMER_SYNC,
        CONSUMER_ASYNCHRONOUS;

    }

    public static enum ProcessingOrder {
        UNORDERED,
        PARTITION,
        KEY;

    }

    public static class ParallelConsumerOptionsBuilder<K, V> {
        private Consumer<K, V> consumer;
        private Producer<K, V> producer;
        private boolean ordering$set;
        private ProcessingOrder ordering$value;
        private boolean commitMode$set;
        private CommitMode commitMode$value;
        private boolean maxNumberMessagesBeyondBaseCommitOffset$set;
        private int maxNumberMessagesBeyondBaseCommitOffset$value;
        private boolean maxMessagesToQueue$set;
        private int maxMessagesToQueue$value;
        private boolean numberOfThreads$set;
        private int numberOfThreads$value;

        ParallelConsumerOptionsBuilder() {
        }

        public ParallelConsumerOptionsBuilder<K, V> consumer(Consumer<K, V> consumer) {
            this.consumer = consumer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> producer(Producer<K, V> producer) {
            this.producer = producer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> ordering(ProcessingOrder ordering) {
            this.ordering$value = ordering;
            this.ordering$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> commitMode(CommitMode commitMode) {
            this.commitMode$value = commitMode;
            this.commitMode$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> maxNumberMessagesBeyondBaseCommitOffset(int maxNumberMessagesBeyondBaseCommitOffset) {
            this.maxNumberMessagesBeyondBaseCommitOffset$value = maxNumberMessagesBeyondBaseCommitOffset;
            this.maxNumberMessagesBeyondBaseCommitOffset$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> maxMessagesToQueue(int maxMessagesToQueue) {
            this.maxMessagesToQueue$value = maxMessagesToQueue;
            this.maxMessagesToQueue$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> numberOfThreads(int numberOfThreads) {
            this.numberOfThreads$value = numberOfThreads;
            this.numberOfThreads$set = true;
            return this;
        }

        public ParallelConsumerOptions<K, V> build() {
            ProcessingOrder ordering$value = this.ordering$value;
            if (!this.ordering$set) {
                ordering$value = ParallelConsumerOptions.$default$ordering();
            }
            CommitMode commitMode$value = this.commitMode$value;
            if (!this.commitMode$set) {
                commitMode$value = ParallelConsumerOptions.$default$commitMode();
            }
            int maxNumberMessagesBeyondBaseCommitOffset$value = this.maxNumberMessagesBeyondBaseCommitOffset$value;
            if (!this.maxNumberMessagesBeyondBaseCommitOffset$set) {
                maxNumberMessagesBeyondBaseCommitOffset$value = ParallelConsumerOptions.$default$maxNumberMessagesBeyondBaseCommitOffset();
            }
            int maxMessagesToQueue$value = this.maxMessagesToQueue$value;
            if (!this.maxMessagesToQueue$set) {
                maxMessagesToQueue$value = ParallelConsumerOptions.$default$maxMessagesToQueue();
            }
            int numberOfThreads$value = this.numberOfThreads$value;
            if (!this.numberOfThreads$set) {
                numberOfThreads$value = ParallelConsumerOptions.$default$numberOfThreads();
            }
            return new ParallelConsumerOptions<K, V>(this.consumer, this.producer, ordering$value, commitMode$value, maxNumberMessagesBeyondBaseCommitOffset$value, maxMessagesToQueue$value, numberOfThreads$value);
        }

        public String toString() {
            return "ParallelConsumerOptions.ParallelConsumerOptionsBuilder(consumer=" + this.consumer + ", producer=" + this.producer + ", ordering$value=" + (Object)((Object)this.ordering$value) + ", commitMode$value=" + (Object)((Object)this.commitMode$value) + ", maxNumberMessagesBeyondBaseCommitOffset$value=" + this.maxNumberMessagesBeyondBaseCommitOffset$value + ", maxMessagesToQueue$value=" + this.maxMessagesToQueue$value + ", numberOfThreads$value=" + this.numberOfThreads$value + ")";
        }
    }
}

