/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.BackportUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingResumingIterator<KEY, VALUE>
implements Iterator<Map.Entry<KEY, VALUE>>,
Iterable<Map.Entry<KEY, VALUE>> {
    private static final Logger log = LoggerFactory.getLogger(LoopingResumingIterator.class);
    private Iterator<Map.Entry<KEY, VALUE>> iterator;
    private final Optional<KEY> iterationStartingPoint;
    private final Map<KEY, VALUE> map;
    private boolean looped = false;
    private Optional<Integer> foundIndex = Optional.empty();
    private int indexOfNextElementToRetrieve = 0;
    private final boolean stillIterateCollectionIfStartingPointDoesntExist = true;

    public static <KKEY, VVALUE> LoopingResumingIterator<KKEY, VVALUE> build(KKEY startingKey, Map<KKEY, VVALUE> map) {
        return new LoopingResumingIterator<KKEY, VVALUE>(Optional.ofNullable(startingKey), map);
    }

    public LoopingResumingIterator(Optional<KEY> startingKey, Map<KEY, VALUE> map) {
        this.iterationStartingPoint = startingKey;
        this.map = map;
        this.iterator = map.entrySet().iterator();
    }

    public LoopingResumingIterator(Map<KEY, VALUE> map) {
        this(Optional.empty(), map);
    }

    @Override
    public boolean hasNext() {
        boolean atEndOfFirstIteration;
        if (BackportUtils.isEmpty(this.iterationStartingPoint)) {
            return this.iterator.hasNext();
        }
        if (this.looped) {
            return this.foundIndex.orElse(-1) != this.indexOfNextElementToRetrieve;
        }
        boolean bl = atEndOfFirstIteration = !this.iterator.hasNext();
        if (atEndOfFirstIteration) {
            this.looped = true;
            if (this.foundIndex.isPresent() && this.foundIndex.get() != 0) {
                this.resetIterator();
                return this.iterator.hasNext();
            }
            return false;
        }
        return true;
    }

    @Override
    public Map.Entry<KEY, VALUE> next() {
        Map.Entry<KEY, VALUE> toReturn = null;
        if (BackportUtils.isEmpty(this.iterationStartingPoint)) {
            toReturn = this.getNext();
        } else {
            KEY lookingFor = this.iterationStartingPoint.get();
            if (this.foundIndex.isPresent()) {
                if (this.looped) {
                    toReturn = this.getNext();
                    if (toReturn.getKey() == lookingFor) {
                        throw new RuntimeException("nope.. cant return false to has next without actually getting next?");
                    }
                } else if (this.iterator.hasNext()) {
                    toReturn = this.getNext();
                } else {
                    this.looped = true;
                    this.resetIterator();
                    toReturn = this.getNext();
                }
            } else {
                while (this.iterator.hasNext()) {
                    Map.Entry<KEY, VALUE> next = this.getNext();
                    if (next.getKey() != lookingFor) continue;
                    this.foundIndex = Optional.of(this.indexOfNextElementToRetrieve - 1);
                    toReturn = next;
                    break;
                }
                if (BackportUtils.isEmpty(this.foundIndex)) {
                    this.foundIndex = Optional.of(0);
                    this.resetIterator();
                    toReturn = this.getNext();
                }
            }
        }
        return toReturn;
    }

    private void resetIterator() {
        this.indexOfNextElementToRetrieve = 0;
        this.iterator = this.map.entrySet().iterator();
    }

    private Map.Entry<KEY, VALUE> getNext() {
        ++this.indexOfNextElementToRetrieve;
        return this.iterator.next();
    }

    @Override
    public Iterator<Map.Entry<KEY, VALUE>> iterator() {
        return this;
    }

    static <KEY, VALUE> void iterateStartingFromKeyLooping(Optional<KEY> key, LinkedHashMap<KEY, VALUE> map, Consumer<Map.Entry<KEY, VALUE>> c) {
        if (key.isPresent()) {
            boolean found = false;
            for (Map.Entry<KEY, VALUE> entry : map.entrySet()) {
                if (!found && !key.equals(entry.getKey())) continue;
                found = true;
                c.accept(entry);
            }
        }
        for (Map.Entry<KEY, VALUE> entry : map.entrySet()) {
            if (key.equals(entry.getKey())) break;
            c.accept(entry);
        }
    }

    public Optional<KEY> getIterationStartingPoint() {
        return this.iterationStartingPoint;
    }
}

