/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.DrainingCloseable;
import io.confluent.parallelconsumer.ParallelConsumer;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import java.util.List;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public interface ParallelStreamProcessor<K, V>
extends ParallelConsumer<K, V>,
DrainingCloseable {
    public static <KK, VV> ParallelStreamProcessor<KK, VV> createEosStreamProcessor(Consumer<KK, VV> consumer, Producer<KK, VV> producer, ParallelConsumerOptions options) {
        return new ParallelEoSStreamProcessor<KK, VV>(consumer, producer, options);
    }

    public void pollAndProduce(Function<ConsumerRecord<K, V>, List<ProducerRecord<K, V>>> var1, java.util.function.Consumer<ConsumeProduceResult<K, V, K, V>> var2);

    public static class ConsumeProduceResult<K, V, KK, VV> {
        private final ConsumerRecord<K, V> in;
        private final ProducerRecord<KK, VV> out;
        private final RecordMetadata meta;

        public ConsumeProduceResult(ConsumerRecord<K, V> in, ProducerRecord<KK, VV> out, RecordMetadata meta) {
            this.in = in;
            this.out = out;
            this.meta = meta;
        }

        public ConsumerRecord<K, V> getIn() {
            return this.in;
        }

        public ProducerRecord<KK, VV> getOut() {
            return this.out;
        }

        public RecordMetadata getMeta() {
            return this.meta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsumeProduceResult)) {
                return false;
            }
            ConsumeProduceResult other = (ConsumeProduceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ConsumerRecord<K, V> this$in = this.getIn();
            ConsumerRecord<K, V> other$in = other.getIn();
            if (this$in == null ? other$in != null : !this$in.equals(other$in)) {
                return false;
            }
            ProducerRecord<KK, VV> this$out = this.getOut();
            ProducerRecord<KK, VV> other$out = other.getOut();
            if (this$out == null ? other$out != null : !this$out.equals(other$out)) {
                return false;
            }
            RecordMetadata this$meta = this.getMeta();
            RecordMetadata other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !this$meta.equals(other$meta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsumeProduceResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ConsumerRecord<K, V> $in = this.getIn();
            result = result * 59 + ($in == null ? 43 : $in.hashCode());
            ProducerRecord<KK, VV> $out = this.getOut();
            result = result * 59 + ($out == null ? 43 : $out.hashCode());
            RecordMetadata $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
            return result;
        }

        public String toString() {
            return "ParallelStreamProcessor.ConsumeProduceResult(in=" + this.getIn() + ", out=" + this.getOut() + ", meta=" + this.getMeta() + ")";
        }
    }
}

