/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

public class ParallelConsumerOptions {
    private final ProcessingOrder ordering;
    private final int maxUncommittedMessagesToHandlePerPartition;
    private final int maxConcurrency;
    private final int numberOfThreads;

    private static ProcessingOrder $default$ordering() {
        return ProcessingOrder.UNORDERED;
    }

    private static int $default$maxUncommittedMessagesToHandlePerPartition() {
        return 1000;
    }

    private static int $default$maxConcurrency() {
        return 100;
    }

    private static int $default$numberOfThreads() {
        return 16;
    }

    ParallelConsumerOptions(ProcessingOrder ordering, int maxUncommittedMessagesToHandlePerPartition, int maxConcurrency, int numberOfThreads) {
        this.ordering = ordering;
        this.maxUncommittedMessagesToHandlePerPartition = maxUncommittedMessagesToHandlePerPartition;
        this.maxConcurrency = maxConcurrency;
        this.numberOfThreads = numberOfThreads;
    }

    public static ParallelConsumerOptionsBuilder builder() {
        return new ParallelConsumerOptionsBuilder();
    }

    public ProcessingOrder getOrdering() {
        return this.ordering;
    }

    public int getMaxUncommittedMessagesToHandlePerPartition() {
        return this.maxUncommittedMessagesToHandlePerPartition;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public static enum ProcessingOrder {
        UNORDERED,
        PARTITION,
        KEY;

    }

    public static class ParallelConsumerOptionsBuilder {
        private boolean ordering$set;
        private ProcessingOrder ordering$value;
        private boolean maxUncommittedMessagesToHandlePerPartition$set;
        private int maxUncommittedMessagesToHandlePerPartition$value;
        private boolean maxConcurrency$set;
        private int maxConcurrency$value;
        private boolean numberOfThreads$set;
        private int numberOfThreads$value;

        ParallelConsumerOptionsBuilder() {
        }

        public ParallelConsumerOptionsBuilder ordering(ProcessingOrder ordering) {
            this.ordering$value = ordering;
            this.ordering$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder maxUncommittedMessagesToHandlePerPartition(int maxUncommittedMessagesToHandlePerPartition) {
            this.maxUncommittedMessagesToHandlePerPartition$value = maxUncommittedMessagesToHandlePerPartition;
            this.maxUncommittedMessagesToHandlePerPartition$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency$value = maxConcurrency;
            this.maxConcurrency$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder numberOfThreads(int numberOfThreads) {
            this.numberOfThreads$value = numberOfThreads;
            this.numberOfThreads$set = true;
            return this;
        }

        public ParallelConsumerOptions build() {
            ProcessingOrder ordering$value = this.ordering$value;
            if (!this.ordering$set) {
                ordering$value = ParallelConsumerOptions.$default$ordering();
            }
            int maxUncommittedMessagesToHandlePerPartition$value = this.maxUncommittedMessagesToHandlePerPartition$value;
            if (!this.maxUncommittedMessagesToHandlePerPartition$set) {
                maxUncommittedMessagesToHandlePerPartition$value = ParallelConsumerOptions.$default$maxUncommittedMessagesToHandlePerPartition();
            }
            int maxConcurrency$value = this.maxConcurrency$value;
            if (!this.maxConcurrency$set) {
                maxConcurrency$value = ParallelConsumerOptions.$default$maxConcurrency();
            }
            int numberOfThreads$value = this.numberOfThreads$value;
            if (!this.numberOfThreads$set) {
                numberOfThreads$value = ParallelConsumerOptions.$default$numberOfThreads();
            }
            return new ParallelConsumerOptions(ordering$value, maxUncommittedMessagesToHandlePerPartition$value, maxConcurrency$value, numberOfThreads$value);
        }

        public String toString() {
            return "ParallelConsumerOptions.ParallelConsumerOptionsBuilder(ordering$value=" + (Object)((Object)this.ordering$value) + ", maxUncommittedMessagesToHandlePerPartition$value=" + this.maxUncommittedMessagesToHandlePerPartition$value + ", maxConcurrency$value=" + this.maxConcurrency$value + ", numberOfThreads$value=" + this.numberOfThreads$value + ")";
        }
    }
}

