/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.EncodedOffsetPair;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.OffsetSimpleSerialisation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetSimultaneousEncoder {
    private static final Logger log = LoggerFactory.getLogger(OffsetSimultaneousEncoder.class);
    public static final int LARGE_INPUT_MAP_SIZE_THRESHOLD = 200;
    private final Set<Long> incompleteOffsets;
    private final long lowWaterMark;
    private final long nextExpectedOffset;
    Map<OffsetEncoding, byte[]> encodingMap = new EnumMap<OffsetEncoding, byte[]>(OffsetEncoding.class);
    TreeSet<EncodedOffsetPair> sortedEncodings = new TreeSet();

    public OffsetSimultaneousEncoder(long lowWaterMark, Long nextExpectedOffset, Set<Long> incompleteOffsets) {
        this.lowWaterMark = lowWaterMark;
        this.nextExpectedOffset = nextExpectedOffset;
        this.incompleteOffsets = incompleteOffsets;
    }

    public OffsetSimultaneousEncoder invoke() {
        log.trace("Starting encode of incompletes of {}", this.incompleteOffsets);
        int length = (int)(this.nextExpectedOffset - this.lowWaterMark);
        if (length > 200) {
            log.debug("~Large input map size: {}", (Object)length);
        }
        HashSet<Encoder> encoders = new HashSet<Encoder>();
        encoders.add(new BitsetEncoder(length));
        encoders.add(new RunLengthEncoder());
        log.debug("Encode loop start,end: [{},{}] length: {}", new Object[]{this.lowWaterMark, this.nextExpectedOffset, length});
        Range.range(length).forEach(rangeIndex -> {
            long offset = this.lowWaterMark + (long)rangeIndex.intValue();
            if (this.incompleteOffsets.contains(offset)) {
                log.trace("Found an incomplete offset {}", (Object)offset);
                encoders.forEach(x -> x.containsIndex((int)rangeIndex));
            } else {
                encoders.forEach(x -> x.doesNotContainIndex((int)rangeIndex));
            }
        });
        this.registerEncodings(encoders);
        log.debug("In order: {}", this.sortedEncodings);
        return this;
    }

    private void registerEncodings(Set<? extends Encoder> encoders) {
        encoders.forEach(Encoder::register);
        boolean noEncodingsAreSmallEnough = encoders.stream().noneMatch(Encoder::quiteSmall);
        if (noEncodingsAreSmallEnough) {
            encoders.forEach(Encoder::registerCompressed);
        }
    }

    public byte[] packSmallest() {
        EncodedOffsetPair best = this.sortedEncodings.first();
        log.debug("Compression chosen is: {}", (Object)best.encoding.name());
        return this.packEncoding(best);
    }

    byte[] packEncoding(EncodedOffsetPair best) {
        boolean magicByteSize = true;
        ByteBuffer result = ByteBuffer.allocate(1 + best.data.capacity());
        result.put(best.encoding.magicByte);
        result.put(best.data);
        return result.array();
    }

    public Set<Long> getIncompleteOffsets() {
        return this.incompleteOffsets;
    }

    public Map<OffsetEncoding, byte[]> getEncodingMap() {
        return this.encodingMap;
    }

    public TreeSet<EncodedOffsetPair> getSortedEncodings() {
        return this.sortedEncodings;
    }

    private class BitsetEncoder
    extends Encoder {
        private final ByteBuffer wrappedBitsetBytesBuffer;
        private final BitSet bitSet;
        private Optional<byte[]> encodedBytes;

        public BitsetEncoder(int length) {
            this.encodedBytes = Optional.empty();
            this.wrappedBitsetBytesBuffer = ByteBuffer.allocate(2 + (length / 8 + 1));
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("Bitset too long to encode: " + length + ". (max: " + Short.MAX_VALUE + ")");
            }
            this.wrappedBitsetBytesBuffer.putShort((short)length);
            this.bitSet = new BitSet(length);
        }

        @Override
        protected OffsetEncoding getEncodingType() {
            return OffsetEncoding.BitSet;
        }

        @Override
        protected OffsetEncoding getEncodingTypeCompressed() {
            return OffsetEncoding.BitSetCompressed;
        }

        @Override
        public void containsIndex(int rangeIndex) {
        }

        @Override
        public void doesNotContainIndex(int rangeIndex) {
            this.bitSet.set(rangeIndex);
        }

        @Override
        public byte[] serialise() {
            byte[] bitSetArray = this.bitSet.toByteArray();
            this.wrappedBitsetBytesBuffer.put(bitSetArray);
            byte[] array = this.wrappedBitsetBytesBuffer.array();
            this.encodedBytes = Optional.of(array);
            return array;
        }

        @Override
        public int getEncodedSize() {
            return this.encodedBytes.get().length;
        }

        @Override
        protected byte[] getEncodedBytes() {
            return this.encodedBytes.get();
        }
    }

    private class RunLengthEncoder
    extends Encoder {
        private final AtomicInteger currentRunLengthCount;
        private final AtomicBoolean previousRunLengthState;
        private final List<Integer> runLengthEncodingIntegers;
        private Optional<byte[]> encodedBytes;

        public RunLengthEncoder() {
            this.encodedBytes = Optional.empty();
            this.currentRunLengthCount = new AtomicInteger();
            this.previousRunLengthState = new AtomicBoolean(false);
            this.runLengthEncodingIntegers = new ArrayList<Integer>();
        }

        @Override
        protected OffsetEncoding getEncodingType() {
            return OffsetEncoding.RunLength;
        }

        @Override
        protected OffsetEncoding getEncodingTypeCompressed() {
            return OffsetEncoding.RunLengthCompressed;
        }

        @Override
        public void containsIndex(int rangeIndex) {
            this.encodeRunLength(false);
        }

        @Override
        public void doesNotContainIndex(int rangeIndex) {
            this.encodeRunLength(true);
        }

        @Override
        public byte[] serialise() {
            this.runLengthEncodingIntegers.add(this.currentRunLengthCount.get());
            ByteBuffer runLengthEncodedByteBuffer = ByteBuffer.allocate(this.runLengthEncodingIntegers.size() * 2);
            for (Integer i : this.runLengthEncodingIntegers) {
                short value = i.shortValue();
                runLengthEncodedByteBuffer.putShort(value);
            }
            byte[] array = runLengthEncodedByteBuffer.array();
            this.encodedBytes = Optional.of(array);
            return array;
        }

        @Override
        public int getEncodedSize() {
            return this.encodedBytes.get().length;
        }

        @Override
        protected byte[] getEncodedBytes() {
            return this.encodedBytes.get();
        }

        private void encodeRunLength(boolean currentIsComplete) {
            boolean currentOffsetMatchesOurRunLengthState;
            boolean bl = currentOffsetMatchesOurRunLengthState = this.previousRunLengthState.get() == currentIsComplete;
            if (currentOffsetMatchesOurRunLengthState) {
                this.currentRunLengthCount.getAndIncrement();
            } else {
                this.previousRunLengthState.set(currentIsComplete);
                this.runLengthEncodingIntegers.add(this.currentRunLengthCount.get());
                this.currentRunLengthCount.set(1);
            }
        }
    }

    private abstract class Encoder {
        private Encoder() {
        }

        protected abstract OffsetEncoding getEncodingType();

        protected abstract OffsetEncoding getEncodingTypeCompressed();

        abstract void containsIndex(int var1);

        abstract void doesNotContainIndex(int var1);

        abstract byte[] serialise();

        abstract int getEncodedSize();

        boolean quiteSmall() {
            return this.getEncodedSize() < 200;
        }

        byte[] compress() throws IOException {
            return OffsetSimpleSerialisation.compressZstd(this.getEncodedBytes());
        }

        final void register() {
            byte[] bytes = this.serialise();
            OffsetEncoding encodingType = this.getEncodingType();
            this.register(encodingType, bytes);
        }

        private void register(OffsetEncoding type, byte[] bytes) {
            OffsetSimultaneousEncoder.this.sortedEncodings.add(new EncodedOffsetPair(type, ByteBuffer.wrap(bytes)));
            OffsetSimultaneousEncoder.this.encodingMap.put(type, bytes);
        }

        void registerCompressed() {
            byte[] compressed = this.compress();
            OffsetEncoding encodingType = this.getEncodingTypeCompressed();
            this.register(encodingType, compressed);
        }

        protected abstract byte[] getEncodedBytes();
    }

    private class ByteBufferEncoder
    extends Encoder {
        private final ByteBuffer bytesBuffer;

        public ByteBufferEncoder(int length) {
            this.bytesBuffer = ByteBuffer.allocate(1 + length);
        }

        @Override
        protected OffsetEncoding getEncodingType() {
            return OffsetEncoding.ByteArray;
        }

        @Override
        protected OffsetEncoding getEncodingTypeCompressed() {
            return OffsetEncoding.ByteArrayCompressed;
        }

        @Override
        public void containsIndex(int rangeIndex) {
            this.bytesBuffer.put((byte)0);
        }

        @Override
        public void doesNotContainIndex(int rangeIndex) {
            this.bytesBuffer.put((byte)1);
        }

        @Override
        public byte[] serialise() {
            return this.bytesBuffer.array();
        }

        @Override
        public int getEncodedSize() {
            return this.bytesBuffer.capacity();
        }

        @Override
        protected byte[] getEncodedBytes() {
            return this.bytesBuffer.array();
        }
    }
}

