/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.log4j.redactor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import io.confluent.log4j.redactor.LogRedactorMetrics;
import io.confluent.log4j.redactor.MetricsTagBuilder;
import io.confluent.log4j.redactor.RedactionPolicyParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringRedactor {
    private RedactionPolicy policy;

    public static StringRedactor emptyStringRedactor(LogRedactorMetrics metrics, Map<String, String> tags) {
        StringRedactor sr = new StringRedactor();
        sr.policy = RedactionPolicy.emptyRedactionPolicy(metrics, tags);
        return sr;
    }

    private StringRedactor() {
    }

    public static StringRedactor createFromJsonFile(String fileName) throws IOException {
        return StringRedactor.createFromJsonFile(fileName, LogRedactorMetrics.NOOP);
    }

    public static StringRedactor createFromJsonFile(String fileName, LogRedactorMetrics metrics) throws IOException {
        StringRedactor sr = new StringRedactor();
        if (fileName == null) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy(metrics, new MetricsTagBuilder().policyLocation("").policyHash("").build());
            return sr;
        }
        File file = new File(fileName);
        if (file.exists() && file.length() == 0L) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy(metrics, new MetricsTagBuilder().policyLocation(fileName).policyHash("").build());
            return sr;
        }
        String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        return StringRedactor.createFromJsonString(content, fileName, metrics);
    }

    public static StringRedactor createFromJsonString(String json, String rulesLocation) throws IOException {
        return StringRedactor.createFromJsonString(json, rulesLocation, LogRedactorMetrics.NOOP);
    }

    public static StringRedactor createFromJsonString(String json, String rulesLocation, LogRedactorMetrics metrics) throws IOException {
        RedactionPolicy policy;
        StringRedactor sr = new StringRedactor();
        if (json == null || json.isEmpty() || rulesLocation == null || rulesLocation.isEmpty()) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy(metrics, new MetricsTagBuilder().policyLocation(rulesLocation).policyContent(json).build());
            return sr;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            policy = (RedactionPolicy)mapper.readValue(json, RedactionPolicy.class);
        }
        catch (JsonProcessingException jpe) {
            throw new RedactionPolicyParseException(jpe.getMessage(), jpe.getCause());
        }
        policy.postProcess();
        sr.policy = policy;
        sr.policy.setupMetrics(metrics, new MetricsTagBuilder().policyLocation(rulesLocation).policyContent(json).build());
        return sr;
    }

    public String redact(String msg) {
        return this.policy.redact(msg);
    }

    public void measureRuleCount() {
        this.policy.measureRuleCount();
    }

    private static class RedactionPolicy {
        private int version = -1;
        private List<RedactionRule> rules;
        public LogRedactorMetrics metrics;
        public Map<String, String> tags;

        private RedactionPolicy() {
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setRules(List<RedactionRule> rules) {
            this.rules = rules;
        }

        public void setupMetrics(LogRedactorMetrics metrics, Map<String, String> tags) {
            this.metrics = metrics;
            this.tags = tags;
            HashMap<String, String> ruleTags = new HashMap<String, String>(tags);
            for (RedactionRule rule : this.rules) {
                if (rule.metricsId == null) continue;
                ruleTags.put("rule", rule.metricsId);
                rule.setTags(ruleTags);
            }
            metrics.count("policy_update", tags);
            this.measureRuleCount();
        }

        private static RedactionPolicy emptyRedactionPolicy(LogRedactorMetrics metrics, Map<String, String> tags) {
            RedactionPolicy policy = new RedactionPolicy();
            policy.version = 1;
            policy.rules = new ArrayList<RedactionRule>();
            policy.setupMetrics(metrics, tags);
            return policy;
        }

        private void postProcess() throws RedactionPolicyParseException {
            if (this.version == -1) {
                throw new RedactionPolicyParseException("No version specified.");
            }
            if (this.version != 1) {
                throw new RedactionPolicyParseException("Unknown version " + this.version);
            }
            for (RedactionRule rule : this.rules) {
                rule.postProcess();
            }
        }

        private String redact(String msg) {
            if (msg == null) {
                return null;
            }
            String original = msg;
            boolean matched = false;
            boolean redacted = false;
            for (RedactionRule rule : this.rules) {
                if (!rule.matchesTrigger(msg)) continue;
                Matcher m = (Matcher)rule.matcherTL.get();
                m.reset((CharSequence)msg);
                if (!m.find()) continue;
                matched = true;
                this.metrics.count("matches", rule.tags);
                if (rule.replace == null) continue;
                msg = m.replaceAll(rule.replace);
                redacted = true;
                if (rule.metricsId == null) continue;
                this.metrics.count("redactions", rule.tags);
            }
            this.metrics.count("scanned_log_statements", this.tags);
            if (matched) {
                this.metrics.count("matched_log_statements", this.tags);
            }
            if (redacted) {
                this.metrics.count("redacted_log_statements", this.tags);
                return msg;
            }
            return original;
        }

        public void measureRuleCount() {
            this.metrics.gauge(this.rules.size(), "policy_rule_count", this.tags);
        }
    }

    private static class RedactionRule {
        private String description;
        private boolean caseSensitive = true;
        private String trigger;
        private String search;
        private String replace;
        private Pattern pattern;
        private ThreadLocal<Matcher> matcherTL;
        private String metricsId;
        private Map<String, String> tags = new HashMap<String, String>();

        private RedactionRule() {
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        public void setMetricsId(String metricsId) {
            this.metricsId = metricsId;
            this.tags.put("rule", metricsId);
        }

        @JsonIgnore
        public void setTags(Map<String, String> tags) {
            this.tags = new HashMap<String, String>(tags);
            this.tags.put("rule", this.metricsId);
        }

        public void setSearch(String search) {
            this.search = search;
            Pattern thrownAway = Pattern.compile((String)search);
        }

        public void setReplace(String replace) {
            this.replace = replace;
        }

        private void postProcess() throws RedactionPolicyParseException {
            if (this.search == null || this.search.isEmpty()) {
                throw new RedactionPolicyParseException("The search regular expression cannot be empty.");
            }
            this.pattern = this.caseSensitive ? Pattern.compile((String)this.search) : Pattern.compile((String)this.search, (int)1);
            this.matcherTL = ThreadLocal.withInitial(() -> this.pattern.matcher((CharSequence)""));
            try {
                String sampleString = "Hello, world";
                Matcher m = this.pattern.matcher((CharSequence)sampleString);
                if (this.replace != null) {
                    sampleString = m.replaceAll(this.replace);
                }
            }
            catch (Exception e) {
                throw new RedactionPolicyParseException("The replacement text \"" + this.replace + "\" is invalid", e);
            }
        }

        private boolean matchesTrigger(String msg) {
            if (this.trigger == null || this.trigger.isEmpty()) {
                return true;
            }
            if (this.caseSensitive) {
                return msg.contains(this.trigger);
            }
            int len = this.trigger.length();
            int max = msg.length() - len;
            for (int i = 0; i <= max; ++i) {
                if (!msg.regionMatches(true, i, this.trigger, 0, len)) continue;
                return true;
            }
            return false;
        }
    }
}

