/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.log4j.redactor;

import io.confluent.log4j.redactor.LogRedactorMetrics;
import io.confluent.log4j.redactor.StringRedactorEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public class RedactorPolicy
implements RewritePolicy,
OptionHandler {
    private static final Logger logger = Logger.getLogger(RedactorPolicy.class);
    private StringRedactorEngine engine;
    private String rulesLocation = "";
    private long refreshIntervalMillis = -1L;
    private int urlReaderTimeoutMillis = 60000;
    private LogRedactorMetrics metrics = StringRedactorEngine.DEFAULT_METRICS;

    public void setMetrics(String metricsClassName) {
        try {
            Class<?> metricsClass = this.getClass().getClassLoader().loadClass(metricsClassName);
            if (LogRedactorMetrics.class.isAssignableFrom(metricsClass)) {
                LogRedactorMetrics metrics;
                Constructor<?> constructor = metricsClass.getConstructor(new Class[0]);
                this.metrics = metrics = (LogRedactorMetrics)constructor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn((Object)("Unable to load custom metrics class: " + metricsClassName + ". Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setRules(String rules) {
        this.rulesLocation = rules;
    }

    public void setRefreshInterval(long interval) {
        this.refreshIntervalMillis = interval;
    }

    public void setTimeOut(int timeOut) {
        this.urlReaderTimeoutMillis = timeOut;
    }

    public synchronized void activateOptions() {
        this.engine = new StringRedactorEngine(this.rulesLocation, this.refreshIntervalMillis, this.urlReaderTimeoutMillis, this.metrics);
    }

    public LoggingEvent rewrite(LoggingEvent source) {
        Object msg;
        if (source != null && (msg = source.getMessage()) != null) {
            String original = msg.toString();
            String redacted = this.engine.getRedactor().redact(original);
            if (!redacted.equals(original)) {
                Throwable throwable = source.getThrowableInformation() != null ? source.getThrowableInformation().getThrowable() : null;
                source = new LoggingEvent(source.getFQNOfLoggerClass(), source.getLogger(), source.getTimeStamp(), (Priority)source.getLevel(), (Object)redacted, throwable);
            }
        }
        return source;
    }
}

