/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.log4j2.redactor;

import io.confluent.log4j.redactor.MetricsInterface;
import io.confluent.log4j.redactor.StringRedactorEngine;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="RedactorPolicy", category="Core", elementType="layout", printObject=true)
public class RedactorPolicy
implements RewritePolicy {
    private StringRedactorEngine redactor;

    @PluginFactory
    public static RedactorPolicy createPolicy(@PluginAttribute(value="name") String name, @PluginAttribute(value="rules") String rules, @PluginAttribute(value="refreshInterval") Long refreshInterval, @PluginAttribute(value="timeOut") Integer timeOut, @PluginElement(value="metrics") MetricsInterface metrics) {
        return new RedactorPolicy(RedactorPolicy.coalesce(rules, ""), RedactorPolicy.coalesce(refreshInterval, -1L), RedactorPolicy.coalesce(timeOut, 60000), RedactorPolicy.coalesce(metrics, StringRedactorEngine.DEFAULT_METRICS));
    }

    private RedactorPolicy(String rules, long refreshInterval, int timeOut, MetricsInterface metrics) {
        this.redactor = new StringRedactorEngine(rules, refreshInterval, timeOut, metrics);
    }

    private static <T> T coalesce(T value, T fallback) {
        return value == null ? fallback : value;
    }

    public LogEvent rewrite(LogEvent source) {
        String redacted;
        String original;
        Message msg;
        if (source != null && (msg = source.getMessage()) != null && (original = msg.getFormattedMessage()) != null && !(redacted = this.redactor.getRedactor().redact(original)).equals(original)) {
            source = new Log4jLogEvent.Builder(source).setMessage((Message)new SimpleMessage(redacted)).build();
        }
        return source;
    }
}

