/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.DrawableRes;
import androidx.annotation.XmlRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\u0016\u0010\f\u001a\u00020\r*\u00020\u00012\b\b\u0001\u0010\u000e\u001a\u00020\tH\u0000\u001a$\u0010\f\u001a\u00020\r*\u00020\u000f2\b\b\u0001\u0010\u000e\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u000fH\u0000\u001a\u001e\u0010\u0012\u001a\u00020\r*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000f2\b\b\u0001\u0010\u000e\u001a\u00020\tH\u0001\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u0001H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"application", "Landroid/content/Context;", "getApplication", "(Landroid/content/Context;)Landroid/content/Context;", "STANDARD_MEMORY_MULTIPLIER", "", "LOW_MEMORY_MULTIPLIER", "defaultMemoryCacheSizePercent", "DEFAULT_MEMORY_CLASS_MEGABYTES", "", "totalAvailableMemoryBytes", "", "getDrawableCompat", "Landroid/graphics/drawable/Drawable;", "resId", "Landroid/content/res/Resources;", "theme", "Landroid/content/res/Resources$Theme;", "getXmlDrawableCompat", "resources", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\ncontexts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 contexts.kt\ncoil3/util/ContextsKt\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n31#2:106\n31#2:107\n1#3:108\n*S KotlinDebug\n*F\n+ 1 contexts.kt\ncoil3/util/ContextsKt\n*L\n32#1:106\n43#1:107\n*E\n"})
public final class ContextsKt {
    private static final double STANDARD_MEMORY_MULTIPLIER = 0.2;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    private static final int DEFAULT_MEMORY_CLASS_MEGABYTES = 256;

    @NotNull
    public static final Context getApplication(@NotNull Context $this$application) {
        return $this$application.getApplicationContext();
    }

    public static final double defaultMemoryCacheSizePercent(@NotNull Context $this$defaultMemoryCacheSizePercent) {
        double d;
        try {
            Context $this$getSystemService$iv = $this$defaultMemoryCacheSizePercent;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv, ActivityManager.class);
            Intrinsics.checkNotNull((Object)object);
            ActivityManager activityManager = (ActivityManager)object;
            d = activityManager.isLowRamDevice() ? 0.15 : 0.2;
        }
        catch (Exception exception) {
            d = 0.2;
        }
        return d;
    }

    public static final long totalAvailableMemoryBytes(@NotNull Context $this$totalAvailableMemoryBytes) {
        int n;
        try {
            Context $this$getSystemService$iv = $this$totalAvailableMemoryBytes;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv, ActivityManager.class);
            Intrinsics.checkNotNull((Object)object);
            ActivityManager activityManager = (ActivityManager)object;
            boolean isLargeHeap = ($this$totalAvailableMemoryBytes.getApplicationInfo().flags & 0x100000) != 0;
            n = isLargeHeap ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
        }
        catch (Exception exception) {
            n = 256;
        }
        int memoryClassMegabytes = n;
        return (long)memoryClassMegabytes * 1024L * 1024L;
    }

    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @DrawableRes int resId) {
        Drawable drawable = AppCompatResources.getDrawable((Context)$this$getDrawableCompat, (int)resId);
        if (drawable == null) {
            boolean bl = false;
            String string = "Invalid resource ID: " + resId;
            throw new IllegalStateException(string.toString());
        }
        return drawable;
    }

    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Resources $this$getDrawableCompat, @DrawableRes int resId, @Nullable Resources.Theme theme) {
        Drawable drawable = ResourcesCompat.getDrawable((Resources)$this$getDrawableCompat, (int)resId, (Resources.Theme)theme);
        if (drawable == null) {
            boolean bl = false;
            String string = "Invalid resource ID: " + resId;
            throw new IllegalStateException(string.toString());
        }
        return drawable;
    }

    @SuppressLint(value={"ResourceType"})
    @NotNull
    public static final Drawable getXmlDrawableCompat(@NotNull Context $this$getXmlDrawableCompat, @NotNull Resources resources, @XmlRes @DrawableRes int resId) {
        XmlResourceParser parser = resources.getXml(resId);
        int type = parser.next();
        while (type != 2 && type != 1) {
            type = parser.next();
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found.");
        }
        if (Build.VERSION.SDK_INT < 24) {
            String string = parser.getName();
            if (Intrinsics.areEqual((Object)string, (Object)"vector")) {
                return (Drawable)VectorDrawableCompat.createFromXmlInner((Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser)), (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
            }
            if (Intrinsics.areEqual((Object)string, (Object)"animated-vector")) {
                return (Drawable)AnimatedVectorDrawableCompat.createFromXmlInner((Context)$this$getXmlDrawableCompat, (Resources)resources, (XmlPullParser)((XmlPullParser)parser), (AttributeSet)Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser)), (Resources.Theme)$this$getXmlDrawableCompat.getTheme());
            }
        }
        return ContextsKt.getDrawableCompat(resources, resId, $this$getXmlDrawableCompat.getTheme());
    }

    @Nullable
    public static final Lifecycle getLifecycle(@Nullable Context $this$getLifecycle) {
        Context context = $this$getLifecycle;
        Context context2;
        while (!((context2 = context) instanceof LifecycleOwner)) {
            if (!(context2 instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return ((LifecycleOwner)context).getLifecycle();
    }
}

