/*
 * Decompiled with CFR 0.152.
 */
package coil3.transition;

import coil3.Image;
import coil3.Image_androidKt;
import coil3.decode.DataSource;
import coil3.request.ErrorResult;
import coil3.request.ImageResult;
import coil3.request.SuccessResult;
import coil3.transition.CrossfadeDrawable;
import coil3.transition.Transition;
import coil3.transition.TransitionTarget;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcoil3/transition/CrossfadeTransition;", "Lcoil3/transition/Transition;", "target", "Lcoil3/transition/TransitionTarget;", "result", "Lcoil3/request/ImageResult;", "durationMillis", "", "preferExactIntrinsicSize", "", "<init>", "(Lcoil3/transition/TransitionTarget;Lcoil3/request/ImageResult;IZ)V", "getDurationMillis", "()I", "getPreferExactIntrinsicSize", "()Z", "transition", "", "Factory", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nCrossfadeTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossfadeTransition.kt\ncoil3/transition/CrossfadeTransition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class CrossfadeTransition
implements Transition {
    @NotNull
    private final TransitionTarget target;
    @NotNull
    private final ImageResult result;
    private final int durationMillis;
    private final boolean preferExactIntrinsicSize;

    @JvmOverloads
    public CrossfadeTransition(@NotNull TransitionTarget target2, @NotNull ImageResult result2, int durationMillis, boolean preferExactIntrinsicSize) {
        this.target = target2;
        this.result = result2;
        this.durationMillis = durationMillis;
        this.preferExactIntrinsicSize = preferExactIntrinsicSize;
        if (!(this.durationMillis > 0)) {
            boolean bl = false;
            String string = "durationMillis must be > 0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CrossfadeTransition(TransitionTarget transitionTarget, ImageResult imageResult, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 200;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(transitionTarget, imageResult, n, bl);
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final boolean getPreferExactIntrinsicSize() {
        return this.preferExactIntrinsicSize;
    }

    @Override
    public void transition() {
        Image image = this.result.getImage();
        CrossfadeDrawable drawable = new CrossfadeDrawable(this.target.getDrawable(), image != null ? Image_androidKt.asDrawable(image, this.target.getView().getResources()) : null, this.result.getRequest().getScale(), this.durationMillis, !(this.result instanceof SuccessResult) || !((SuccessResult)this.result).isPlaceholderCached(), this.preferExactIntrinsicSize);
        ImageResult imageResult = this.result;
        if (imageResult instanceof SuccessResult) {
            this.target.onSuccess(Image_androidKt.asImage(drawable));
        } else if (imageResult instanceof ErrorResult) {
            this.target.onError(Image_androidKt.asImage(drawable));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @JvmOverloads
    public CrossfadeTransition(@NotNull TransitionTarget target2, @NotNull ImageResult result2, int durationMillis) {
        this(target2, result2, durationMillis, false, 8, null);
    }

    @JvmOverloads
    public CrossfadeTransition(@NotNull TransitionTarget target2, @NotNull ImageResult result2) {
        this(target2, result2, 0, false, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcoil3/transition/CrossfadeTransition$Factory;", "Lcoil3/transition/Transition$Factory;", "durationMillis", "", "preferExactIntrinsicSize", "", "<init>", "(IZ)V", "getDurationMillis", "()I", "getPreferExactIntrinsicSize", "()Z", "create", "Lcoil3/transition/Transition;", "target", "Lcoil3/transition/TransitionTarget;", "result", "Lcoil3/request/ImageResult;", "coil-core_release"})
    @SourceDebugExtension(value={"SMAP\nCrossfadeTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossfadeTransition.kt\ncoil3/transition/CrossfadeTransition$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
    public static final class Factory
    implements Transition.Factory {
        private final int durationMillis;
        private final boolean preferExactIntrinsicSize;

        @JvmOverloads
        public Factory(int durationMillis, boolean preferExactIntrinsicSize) {
            this.durationMillis = durationMillis;
            this.preferExactIntrinsicSize = preferExactIntrinsicSize;
            if (!(this.durationMillis > 0)) {
                boolean bl = false;
                String string = "durationMillis must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Factory(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 200;
            }
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(n, bl);
        }

        public final int getDurationMillis() {
            return this.durationMillis;
        }

        public final boolean getPreferExactIntrinsicSize() {
            return this.preferExactIntrinsicSize;
        }

        @Override
        @NotNull
        public Transition create(@NotNull TransitionTarget target2, @NotNull ImageResult result2) {
            if (!(result2 instanceof SuccessResult)) {
                return Transition.Factory.NONE.create(target2, result2);
            }
            if (((SuccessResult)result2).getDataSource() == DataSource.MEMORY_CACHE) {
                return Transition.Factory.NONE.create(target2, result2);
            }
            return new CrossfadeTransition(target2, result2, this.durationMillis, this.preferExactIntrinsicSize);
        }

        @JvmOverloads
        public Factory(int durationMillis) {
            this(durationMillis, false, 2, null);
        }

        @JvmOverloads
        public Factory() {
            this(0, false, 3, null);
        }
    }
}

