/*
 * Decompiled with CFR 0.152.
 */
package coil3.size;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import coil3.decode.DecodeUtils;
import coil3.size.Scale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0017J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0016H\u0014J\b\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0001H\u0016J \u0010/\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0016H\u0016J\u0012\u00104\u001a\u00020\u00122\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020\u00122\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010:\u001a\u00020\u00122\b\u0010;\u001a\u0004\u0018\u00010<H\u0017J\b\u0010=\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020\u0012H\u0016J\b\u0010?\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcoil3/size/ScaleDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroid/graphics/drawable/Animatable;", "child", "scale", "Lcoil3/size/Scale;", "<init>", "(Landroid/graphics/drawable/Drawable;Lcoil3/size/Scale;)V", "getChild", "()Landroid/graphics/drawable/Drawable;", "getScale", "()Lcoil3/size/Scale;", "childDx", "", "childDy", "childScale", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "", "setAlpha", "alpha", "getOpacity", "getColorFilter", "Landroid/graphics/ColorFilter;", "setColorFilter", "colorFilter", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "isStateful", "", "onStateChange", "state", "", "onLevelChange", "level", "getIntrinsicWidth", "getIntrinsicHeight", "unscheduleDrawable", "who", "what", "Ljava/lang/Runnable;", "invalidateDrawable", "scheduleDrawable", "when", "", "setTint", "tintColor", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "isRunning", "start", "stop", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nScaleDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleDrawable.kt\ncoil3/size/ScaleDrawable\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,121:1\n30#2,7:122\n*S KotlinDebug\n*F\n+ 1 ScaleDrawable.kt\ncoil3/size/ScaleDrawable\n*L\n35#1:122,7\n*E\n"})
public final class ScaleDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    @NotNull
    private final Drawable child;
    @NotNull
    private final Scale scale;
    private float childDx;
    private float childDy;
    private float childScale;

    @JvmOverloads
    public ScaleDrawable(@NotNull Drawable child, @NotNull Scale scale) {
        this.child = child;
        this.scale = scale;
        this.childScale = 1.0f;
        this.child.setCallback((Drawable.Callback)this);
    }

    public /* synthetic */ ScaleDrawable(Drawable drawable, Scale scale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scale = Scale.FIT;
        }
        this(drawable, scale);
    }

    @NotNull
    public final Drawable getChild() {
        return this.child;
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$draw_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            $this$draw_u24lambda_u240.translate(this.childDx, this.childDy);
            $this$draw_u24lambda_u240.scale(this.childScale, this.childScale);
            this.child.draw($this$draw_u24lambda_u240);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    public int getAlpha() {
        return this.child.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.child.setAlpha(alpha);
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        return this.child.getOpacity();
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.child.getColorFilter();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.child.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        int width = this.child.getIntrinsicWidth();
        int height = this.child.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            this.child.setBounds(bounds);
            this.childDx = 0.0f;
            this.childDy = 0.0f;
            this.childScale = 1.0f;
            return;
        }
        int targetWidth = bounds.width();
        int targetHeight = bounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int left = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int top = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        int right = left + width;
        int bottom = top + height;
        this.child.setBounds(left, top, right, bottom);
        this.childDx = bounds.left;
        this.childDy = bounds.top;
        this.childScale = (float)multiplier;
    }

    public boolean isStateful() {
        return this.child.isStateful();
    }

    protected boolean onStateChange(@NotNull int[] state) {
        return this.child.setState(state);
    }

    protected boolean onLevelChange(int level) {
        return this.child.setLevel(level);
    }

    public int getIntrinsicWidth() {
        return this.child.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.child.getIntrinsicHeight();
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void setTint(int tintColor) {
        this.child.setTint(tintColor);
    }

    public void setTintList(@Nullable ColorStateList tint) {
        this.child.setTintList(tint);
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.child.setTintMode(tintMode);
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        this.child.setTintBlendMode(blendMode);
    }

    public boolean isRunning() {
        return this.child instanceof Animatable && ((Animatable)this.child).isRunning();
    }

    public void start() {
        if (this.child instanceof Animatable) {
            ((Animatable)this.child).start();
        }
    }

    public void stop() {
        if (this.child instanceof Animatable) {
            ((Animatable)this.child).stop();
        }
    }

    @JvmOverloads
    public ScaleDrawable(@NotNull Drawable child) {
        this(child, null, 2, null);
    }
}

