/*
 * Decompiled with CFR 0.152.
 */
package coil3.fetch;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import coil3.ImageLoader;
import coil3.Uri;
import coil3.UriKt;
import coil3.Uri_androidKt;
import coil3.decode.ContentMetadata;
import coil3.decode.DataSource;
import coil3.decode.ImageSourceKt;
import coil3.fetch.FetchResult;
import coil3.fetch.Fetcher;
import coil3.fetch.SourceFetchResult;
import coil3.request.Options;
import coil3.size.Dimension;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\rJ\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil3/fetch/ContentUriFetcher;", "Lcoil3/fetch/Fetcher;", "data", "Lcoil3/Uri;", "options", "Lcoil3/request/Options;", "<init>", "(Lcoil3/Uri;Lcoil3/request/Options;)V", "fetch", "Lcoil3/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isContactPhotoUri", "", "isContactPhotoUri$coil_core_release", "isMusicThumbnailUri", "isMusicThumbnailUri$coil_core_release", "newMusicThumbnailSizeOptions", "Landroid/os/Bundle;", "Factory", "coil-core_release"})
@SourceDebugExtension(value={"SMAP\nContentUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentUriFetcher.kt\ncoil3/fetch/ContentUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class ContentUriFetcher
implements Fetcher {
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;

    public ContentUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        AssetFileDescriptor assetFileDescriptor;
        android.net.Uri androidUri = Uri_androidKt.toAndroidUri(this.data);
        ContentResolver contentResolver = this.options.getContext().getContentResolver();
        if (this.isContactPhotoUri$coil_core_release(this.data)) {
            AssetFileDescriptor afd = contentResolver.openAssetFileDescriptor(androidUri, "r");
            assetFileDescriptor = afd;
            if (assetFileDescriptor == null) {
                boolean $i$a$-checkNotNull-ContentUriFetcher$fetch$afd$42 = false;
                String $i$a$-checkNotNull-ContentUriFetcher$fetch$afd$42 = "Unable to find a contact photo associated with '" + androidUri + "'.";
                throw new IllegalStateException($i$a$-checkNotNull-ContentUriFetcher$fetch$afd$42.toString());
            }
        } else if (Build.VERSION.SDK_INT >= 29 && this.isMusicThumbnailUri$coil_core_release(this.data)) {
            Bundle bundle = this.newMusicThumbnailSizeOptions();
            AssetFileDescriptor afd = contentResolver.openTypedAssetFile(androidUri, "image/*", bundle, null);
            assetFileDescriptor = afd;
            if (assetFileDescriptor == null) {
                boolean bl = false;
                String string = "Unable to find a music thumbnail associated with '" + androidUri + "'.";
                throw new IllegalStateException(string.toString());
            }
        } else {
            AssetFileDescriptor stream = contentResolver.openAssetFileDescriptor(androidUri, "r");
            assetFileDescriptor = stream;
            if (assetFileDescriptor == null) {
                boolean bl = false;
                String string = "Unable to open '" + androidUri + "'.";
                throw new IllegalStateException(string.toString());
            }
        }
        AssetFileDescriptor afd = assetFileDescriptor;
        return new SourceFetchResult(ImageSourceKt.ImageSource(Okio.buffer((Source)Okio.source((InputStream)afd.createInputStream())), this.options.getFileSystem(), new ContentMetadata(this.data, afd)), contentResolver.getType(androidUri), DataSource.DISK);
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$coil_core_release(@NotNull Uri data) {
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(UriKt.getPathSegments(data)), (Object)"display_photo");
    }

    @VisibleForTesting
    public final boolean isMusicThumbnailUri$coil_core_release(@NotNull Uri data) {
        if (!Intrinsics.areEqual((Object)data.getAuthority(), (Object)"media")) {
            return false;
        }
        List<String> segments = UriKt.getPathSegments(data);
        int size2 = segments.size();
        return size2 >= 3 && Intrinsics.areEqual((Object)segments.get(size2 - 3), (Object)"audio") && Intrinsics.areEqual((Object)segments.get(size2 - 2), (Object)"albums");
    }

    private final Bundle newMusicThumbnailSizeOptions() {
        Dimension dimension = this.options.getSize().getWidth();
        Dimension.Pixels pixels = dimension instanceof Dimension.Pixels ? (Dimension.Pixels)dimension : null;
        if (pixels == null) {
            return null;
        }
        int width = pixels.unbox-impl();
        Dimension dimension2 = this.options.getSize().getHeight();
        Dimension.Pixels pixels2 = dimension2 instanceof Dimension.Pixels ? (Dimension.Pixels)dimension2 : null;
        if (pixels2 == null) {
            return null;
        }
        int height = pixels2.unbox-impl();
        Dimension $this$newMusicThumbnailSizeOptions_u24lambda_u243 = dimension = new Bundle(1);
        boolean bl = false;
        $this$newMusicThumbnailSizeOptions_u24lambda_u243.putParcelable("android.content.extra.SIZE", (Parcelable)new Point(width, height));
        return dimension;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lcoil3/fetch/ContentUriFetcher$Factory;", "Lcoil3/fetch/Fetcher$Factory;", "Lcoil3/Uri;", "<init>", "()V", "create", "Lcoil3/fetch/Fetcher;", "data", "options", "Lcoil3/request/Options;", "imageLoader", "Lcoil3/ImageLoader;", "isApplicable", "", "coil-core_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ContentUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
        }
    }
}

