/*
 * Decompiled with CFR 0.152.
 */
package coil.network;

import coil.network.CacheResponse;
import coil.util.-Utils;
import coil.util.Time;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcoil/network/CacheStrategy;", "", "networkRequest", "Lokhttp3/Request;", "cacheResponse", "Lcoil/network/CacheResponse;", "(Lokhttp3/Request;Lcoil/network/CacheResponse;)V", "getCacheResponse", "()Lcoil/network/CacheResponse;", "getNetworkRequest", "()Lokhttp3/Request;", "Companion", "Factory", "coil-base_release"})
public final class CacheStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Request networkRequest;
    @Nullable
    private final CacheResponse cacheResponse;

    private CacheStrategy(Request networkRequest, CacheResponse cacheResponse) {
        this.networkRequest = networkRequest;
        this.cacheResponse = cacheResponse;
    }

    @Nullable
    public final Request getNetworkRequest() {
        return this.networkRequest;
    }

    @Nullable
    public final CacheResponse getCacheResponse() {
        return this.cacheResponse;
    }

    public /* synthetic */ CacheStrategy(Request networkRequest, CacheResponse cacheResponse, DefaultConstructorMarker $constructor_marker) {
        this(networkRequest, cacheResponse);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoil/network/CacheStrategy$Factory;", "", "request", "Lokhttp3/Request;", "cacheResponse", "Lcoil/network/CacheResponse;", "(Lokhttp3/Request;Lcoil/network/CacheResponse;)V", "ageSeconds", "", "etag", "", "expires", "Ljava/util/Date;", "lastModified", "lastModifiedString", "receivedResponseMillis", "", "sentRequestMillis", "servedDate", "servedDateString", "cacheResponseAge", "compute", "Lcoil/network/CacheStrategy;", "computeFreshnessLifetime", "hasConditions", "", "coil-base_release"})
    public static final class Factory {
        @NotNull
        private final Request request;
        @Nullable
        private final CacheResponse cacheResponse;
        @Nullable
        private Date servedDate;
        @Nullable
        private String servedDateString;
        @Nullable
        private Date lastModified;
        @Nullable
        private String lastModifiedString;
        @Nullable
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        @Nullable
        private String etag;
        private int ageSeconds;

        public Factory(@NotNull Request request, @Nullable CacheResponse cacheResponse) {
            this.request = request;
            this.cacheResponse = cacheResponse;
            this.ageSeconds = -1;
            if (this.cacheResponse != null) {
                this.sentRequestMillis = this.cacheResponse.getSentRequestAtMillis();
                this.receivedResponseMillis = this.cacheResponse.getReceivedResponseAtMillis();
                Headers headers = this.cacheResponse.getResponseHeaders();
                int n = 0;
                int n2 = headers.size();
                while (n < n2) {
                    int i = n++;
                    String name = headers.name(i);
                    String value = headers.value(i);
                    if (StringsKt.equals((String)name, (String)"Date", (boolean)true)) {
                        this.servedDate = headers.getDate("Date");
                        this.servedDateString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)name, (String)"Expires", (boolean)true)) {
                        this.expires = headers.getDate("Expires");
                        continue;
                    }
                    if (StringsKt.equals((String)name, (String)"Last-Modified", (boolean)true)) {
                        this.lastModified = headers.getDate("Last-Modified");
                        this.lastModifiedString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)name, (String)"ETag", (boolean)true)) {
                        this.etag = value;
                        continue;
                    }
                    if (!StringsKt.equals((String)name, (String)"Age", (boolean)true)) continue;
                    this.ageSeconds = -Utils.toNonNegativeInt(value, -1);
                }
            }
        }

        @NotNull
        public final CacheStrategy compute() {
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, null, null);
            }
            if (this.request.isHttps() && !this.cacheResponse.isTls()) {
                return new CacheStrategy(this.request, null, null);
            }
            CacheControl responseCaching = this.cacheResponse.getCacheControl();
            if (!Companion.isCacheable(this.request, this.cacheResponse)) {
                return new CacheStrategy(this.request, null, null);
            }
            CacheControl requestCaching = this.request.cacheControl();
            if (requestCaching.noCache() || this.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null, null);
            }
            long ageMillis = this.cacheResponseAge();
            long freshMillis = this.computeFreshnessLifetime();
            if (requestCaching.maxAgeSeconds() != -1) {
                long l = TimeUnit.SECONDS.toMillis(requestCaching.maxAgeSeconds());
                freshMillis = Math.min(freshMillis, l);
            }
            long minFreshMillis = 0L;
            if (requestCaching.minFreshSeconds() != -1) {
                minFreshMillis = TimeUnit.SECONDS.toMillis(requestCaching.minFreshSeconds());
            }
            long maxStaleMillis = 0L;
            if (!responseCaching.mustRevalidate() && requestCaching.maxStaleSeconds() != -1) {
                maxStaleMillis = TimeUnit.SECONDS.toMillis(requestCaching.maxStaleSeconds());
            }
            if (!responseCaching.noCache() && ageMillis + minFreshMillis < freshMillis + maxStaleMillis) {
                return new CacheStrategy(null, this.cacheResponse, null);
            }
            String conditionName = null;
            String conditionValue = null;
            if (this.etag != null) {
                conditionName = "If-None-Match";
                conditionValue = this.etag;
            } else if (this.lastModified != null) {
                conditionName = "If-Modified-Since";
                conditionValue = this.lastModifiedString;
            } else if (this.servedDate != null) {
                conditionName = "If-Modified-Since";
                conditionValue = this.servedDateString;
            } else {
                return new CacheStrategy(this.request, null, null);
            }
            Headers.Builder conditionalRequestHeaders = this.request.headers().newBuilder();
            String string = conditionValue;
            Intrinsics.checkNotNull((Object)string);
            conditionalRequestHeaders.add(conditionName, string);
            Request conditionalRequest = this.request.newBuilder().headers(conditionalRequestHeaders.build()).build();
            return new CacheStrategy(conditionalRequest, this.cacheResponse, null);
        }

        private final long computeFreshnessLifetime() {
            CacheResponse cacheResponse = this.cacheResponse;
            Intrinsics.checkNotNull((Object)cacheResponse);
            CacheControl responseCaching = cacheResponse.getCacheControl();
            if (responseCaching.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(responseCaching.maxAgeSeconds());
            }
            Date expires = this.expires;
            if (expires != null) {
                Date date = this.servedDate;
                Long l = date == null ? null : Long.valueOf(date.getTime());
                long servedMillis = l == null ? this.receivedResponseMillis : l;
                long delta = expires.getTime() - servedMillis;
                return delta > 0L ? delta : 0L;
            }
            if (this.lastModified != null && this.request.url().query() == null) {
                Date date = this.servedDate;
                Long l = date == null ? null : Long.valueOf(date.getTime());
                long servedMillis = l == null ? this.sentRequestMillis : l;
                Date date2 = this.lastModified;
                Intrinsics.checkNotNull((Object)date2);
                long delta = servedMillis - date2.getTime();
                return delta > 0L ? delta / (long)10 : 0L;
            }
            return 0L;
        }

        private final long cacheResponseAge() {
            long l;
            long apparentReceivedAge;
            long l2;
            long l3;
            Date servedDate = this.servedDate;
            if (servedDate != null) {
                long l4 = 0L;
                l3 = this.receivedResponseMillis - servedDate.getTime();
                l2 = Math.max(l4, l3);
            } else {
                l2 = apparentReceivedAge = 0L;
            }
            if (this.ageSeconds != -1) {
                l3 = TimeUnit.SECONDS.toMillis(this.ageSeconds);
                l = Math.max(apparentReceivedAge, l3);
            } else {
                l = apparentReceivedAge;
            }
            long receivedAge = l;
            long responseDuration = this.receivedResponseMillis - this.sentRequestMillis;
            long residentDuration = Time.INSTANCE.currentMillis() - this.receivedResponseMillis;
            return receivedAge + responseDuration + residentDuration;
        }

        private final boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcoil/network/CacheStrategy$Companion;", "", "()V", "combineHeaders", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "isCacheable", "", "request", "Lokhttp3/Request;", "response", "Lcoil/network/CacheResponse;", "Lokhttp3/Response;", "isContentSpecificHeader", "name", "", "isEndToEnd", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCacheable(@NotNull Request request, @NotNull Response response) {
            return !request.cacheControl().noStore() && !response.cacheControl().noStore() && !Intrinsics.areEqual((Object)response.headers().get("Vary"), (Object)"*");
        }

        public final boolean isCacheable(@NotNull Request request, @NotNull CacheResponse response) {
            return !request.cacheControl().noStore() && !response.getCacheControl().noStore() && !Intrinsics.areEqual((Object)response.getResponseHeaders().get("Vary"), (Object)"*");
        }

        @NotNull
        public final Headers combineHeaders(@NotNull Headers cachedHeaders, @NotNull Headers networkHeaders) {
            int index;
            Headers.Builder result2 = new Headers.Builder();
            int n = 0;
            int n2 = cachedHeaders.size();
            while (n < n2) {
                index = n++;
                String name = cachedHeaders.name(index);
                String value = cachedHeaders.value(index);
                if (StringsKt.equals((String)"Warning", (String)name, (boolean)true) && StringsKt.startsWith$default((String)value, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(name) && this.isEndToEnd(name) && networkHeaders.get(name) != null) continue;
                result2.add(name, value);
            }
            n = 0;
            n2 = networkHeaders.size();
            while (n < n2) {
                String fieldName;
                if (this.isContentSpecificHeader(fieldName = networkHeaders.name(index = n++)) || !this.isEndToEnd(fieldName)) continue;
                result2.add(fieldName, networkHeaders.value(index));
            }
            return result2.build();
        }

        private final boolean isEndToEnd(String name) {
            return !StringsKt.equals((String)"Connection", (String)name, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)name, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)name, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)name, (boolean)true) && !StringsKt.equals((String)"TE", (String)name, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)name, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)name, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)name, (boolean)true);
        }

        private final boolean isContentSpecificHeader(String name) {
            return StringsKt.equals((String)"Content-Length", (String)name, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)name, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)name, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

