/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import coil.memory.EmptyStrongMemoryCache;
import coil.memory.EmptyWeakMemoryCache;
import coil.memory.RealMemoryCache;
import coil.memory.RealStrongMemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.util.-Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aJ\b\u0010\r\u001a\u00020\u000eH&J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u00a6\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0004H&J\u0019\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0010H\u00a6\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcoil/memory/MemoryCache;", "", "keys", "", "Lcoil/memory/MemoryCache$Key;", "getKeys", "()Ljava/util/Set;", "maxSize", "", "getMaxSize", "()I", "size", "getSize", "clear", "", "get", "Lcoil/memory/MemoryCache$Value;", "key", "remove", "", "set", "value", "trimMemory", "level", "Builder", "Key", "Value", "coil-base_release"})
public interface MemoryCache {
    public int getSize();

    public int getMaxSize();

    @NotNull
    public Set<Key> getKeys();

    @Nullable
    public Value get(@NotNull Key var1);

    public void set(@NotNull Key var1, @NotNull Value var2);

    public boolean remove(@NotNull Key var1);

    public void clear();

    public void trimMemory(int var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcoil/memory/MemoryCache$Key;", "Landroid/os/Parcelable;", "key", "", "extras", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getExtras", "()Ljava/util/Map;", "getKey", "()Ljava/lang/String;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "coil-base_release"})
    @Parcelize
    public static final class Key
    implements Parcelable {
        @NotNull
        private final String key;
        @NotNull
        private final Map<String, String> extras;
        @NotNull
        public static final Parcelable.Creator<Key> CREATOR;

        public Key(@NotNull String key, @NotNull Map<String, String> extras) {
            this.key = key;
            this.extras = extras;
        }

        public /* synthetic */ Key(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, map);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Map<String, String> getExtras() {
            return this.extras;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.extras;
        }

        @NotNull
        public final Key copy(@NotNull String key, @NotNull Map<String, String> extras) {
            return new Key(key, extras);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.key;
            }
            if ((n & 2) != 0) {
                map = key.extras;
            }
            return key.copy(string, map);
        }

        @NotNull
        public String toString() {
            return "Key(key=" + this.key + ", extras=" + this.extras + ')';
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + ((Object)this.extras).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)key.key)) {
                return false;
            }
            return Intrinsics.areEqual(this.extras, key.extras);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            out.writeString(this.key);
            Map<String, String> map = this.extras;
            out.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Key> {
                @NotNull
                public final Key[] newArray(int size2) {
                    return new Key[size2];
                }

                @NotNull
                public final Key createFromParcel(@NotNull Parcel parcel) {
                    int n = parcel.readInt();
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(n);
                    String string = parcel.readString();
                    for (int i = 0; i != n; ++i) {
                        linkedHashMap.put(parcel.readString(), parcel.readString());
                    }
                    Map map = linkedHashMap;
                    String string2 = string;
                    return new Key(string2, map);
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcoil/memory/MemoryCache$Value;", "", "bitmap", "Landroid/graphics/Bitmap;", "extras", "", "", "(Landroid/graphics/Bitmap;Ljava/util/Map;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getExtras", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "coil-base_release"})
    public static final class Value {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Map<String, Object> extras;

        public Value(@NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras) {
            this.bitmap = bitmap;
            this.extras = extras;
        }

        public /* synthetic */ Value(Bitmap bitmap, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(bitmap, map);
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        @NotNull
        public final Bitmap component1() {
            return this.bitmap;
        }

        @NotNull
        public final Map<String, Object> component2() {
            return this.extras;
        }

        @NotNull
        public final Value copy(@NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras) {
            return new Value(bitmap, extras);
        }

        public static /* synthetic */ Value copy$default(Value value, Bitmap bitmap, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = value.bitmap;
            }
            if ((n & 2) != 0) {
                map = value.extras;
            }
            return value.copy(bitmap, map);
        }

        @NotNull
        public String toString() {
            return "Value(bitmap=" + this.bitmap + ", extras=" + this.extras + ')';
        }

        public int hashCode() {
            int result2 = this.bitmap.hashCode();
            result2 = result2 * 31 + ((Object)this.extras).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Value)) {
                return false;
            }
            Value value = (Value)other;
            if (!Intrinsics.areEqual((Object)this.bitmap, (Object)value.bitmap)) {
                return false;
            }
            return Intrinsics.areEqual(this.extras, value.extras);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\b\b\u0001\u0010\u000f\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcoil/memory/MemoryCache$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "maxSizeBytes", "", "maxSizePercent", "", "strongReferencesEnabled", "", "weakReferencesEnabled", "build", "Lcoil/memory/MemoryCache;", "size", "percent", "enable", "coil-base_release"})
    public static final class Builder {
        @NotNull
        private final Context context;
        private double maxSizePercent;
        private int maxSizeBytes;
        private boolean strongReferencesEnabled;
        private boolean weakReferencesEnabled;

        public Builder(@NotNull Context context) {
            this.context = context;
            this.maxSizePercent = -Utils.defaultMemoryCacheSizePercent(this.context);
            this.strongReferencesEnabled = true;
            this.weakReferencesEnabled = true;
        }

        @NotNull
        public final Builder maxSizePercent(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "size must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u2d1.maxSizeBytes = 0;
            $this$maxSizePercent_u24lambda_u2d1.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(int size2) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            if (!(size2 >= 0)) {
                boolean bl2 = false;
                String string = "size must be >= 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u2d3.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u2d3.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder strongReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$strongReferencesEnabled_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$strongReferencesEnabled_u24lambda_u2d4.strongReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final Builder weakReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$weakReferencesEnabled_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$weakReferencesEnabled_u24lambda_u2d5.weakReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final MemoryCache build() {
            StrongMemoryCache strongMemoryCache;
            WeakMemoryCache weakMemoryCache;
            WeakMemoryCache weakMemoryCache2 = weakMemoryCache = this.weakReferencesEnabled ? (WeakMemoryCache)new RealWeakMemoryCache() : (WeakMemoryCache)new EmptyWeakMemoryCache();
            if (this.strongReferencesEnabled) {
                int maxSize;
                int n = maxSize = this.maxSizePercent > 0.0 ? -Utils.calculateMemoryCacheSize(this.context, this.maxSizePercent) : this.maxSizeBytes;
                strongMemoryCache = maxSize > 0 ? (StrongMemoryCache)new RealStrongMemoryCache(maxSize, weakMemoryCache) : (StrongMemoryCache)new EmptyStrongMemoryCache(weakMemoryCache);
            } else {
                strongMemoryCache = new EmptyStrongMemoryCache(weakMemoryCache);
            }
            StrongMemoryCache strongMemoryCache2 = strongMemoryCache;
            return new RealMemoryCache(strongMemoryCache2, weakMemoryCache);
        }
    }
}

