/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import coil.EventListener;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.DecodeUtils;
import coil.intercept.EngineInterceptor;
import coil.intercept.Interceptor;
import coil.memory.MemoryCache;
import coil.request.ImageRequest;
import coil.request.Options;
import coil.request.RequestService;
import coil.request.SuccessResult;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.-Bitmaps;
import coil.util.-Requests;
import coil.util.-Utils;
import coil.util.Logger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J-\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u001aJ(\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000bJ \u0010&\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(J\u0014\u0010)\u001a\u00020**\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006/"}, d2={"Lcoil/memory/MemoryCacheService;", "", "imageLoader", "Lcoil/ImageLoader;", "requestService", "Lcoil/request/RequestService;", "logger", "Lcoil/util/Logger;", "(Lcoil/ImageLoader;Lcoil/request/RequestService;Lcoil/util/Logger;)V", "diskCacheKey", "", "Lcoil/memory/MemoryCache$Value;", "getDiskCacheKey", "(Lcoil/memory/MemoryCache$Value;)Ljava/lang/String;", "isSampled", "", "(Lcoil/memory/MemoryCache$Value;)Z", "getCacheValue", "request", "Lcoil/request/ImageRequest;", "cacheKey", "Lcoil/memory/MemoryCache$Key;", "size", "Lcoil/size/Size;", "isCacheValueValid", "cacheValue", "isCacheValueValid$coil_base_release", "isSizeValid", "newCacheKey", "mappedData", "options", "Lcoil/request/Options;", "eventListener", "Lcoil/EventListener;", "newResult", "Lcoil/request/SuccessResult;", "chain", "Lcoil/intercept/Interceptor$Chain;", "setCacheValue", "result", "Lcoil/intercept/EngineInterceptor$ExecuteResult;", "pxOrMinMax", "", "Lcoil/size/Dimension;", "scale", "Lcoil/size/Scale;", "Companion", "coil-base_release"})
public final class MemoryCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final RequestService requestService;
    @Nullable
    private final Logger logger;
    @NotNull
    private static final String TAG = "MemoryCacheService";
    @NotNull
    public static final String EXTRA_TRANSFORMATION_INDEX = "coil#transformation_";
    @NotNull
    public static final String EXTRA_TRANSFORMATION_SIZE = "coil#transformation_size";
    @NotNull
    public static final String EXTRA_IS_SAMPLED = "coil#is_sampled";
    @NotNull
    public static final String EXTRA_DISK_CACHE_KEY = "coil#disk_cache_key";

    public MemoryCacheService(@NotNull ImageLoader imageLoader, @NotNull RequestService requestService, @Nullable Logger logger) {
        this.imageLoader = imageLoader;
        this.requestService = requestService;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MemoryCache.Key newCacheKey(@NotNull ImageRequest request, @NotNull Object mappedData, @NotNull Options options, @NotNull EventListener eventListener) {
        MemoryCache.Key key = request.getMemoryCacheKey();
        if (key != null) {
            MemoryCache.Key it = key;
            boolean bl = false;
            return it;
        }
        eventListener.keyStart(request, mappedData);
        String base = this.imageLoader.getComponents().key(mappedData, options);
        eventListener.keyEnd(request, base);
        if (base == null) {
            return null;
        }
        List<Transformation> transformations = request.getTransformations();
        Map<String, String> parameterKeys = request.getParameters().memoryCacheKeys();
        if (transformations.isEmpty() && parameterKeys.isEmpty()) {
            return new MemoryCache.Key(base, null, 2, null);
        }
        Map extras = MapsKt.toMutableMap(parameterKeys);
        if (!((Collection)transformations).isEmpty()) {
            List<Transformation> $this$forEachIndexedIndices$iv = request.getTransformations();
            boolean $i$f$forEachIndexedIndices = false;
            int n = 0;
            int n2 = $this$forEachIndexedIndices$iv.size();
            while (n < n2) {
                void transformation;
                int i$iv = n++;
                Transformation transformation2 = $this$forEachIndexedIndices$iv.get(i$iv);
                int index = i$iv;
                boolean bl = false;
                extras.put(Intrinsics.stringPlus((String)EXTRA_TRANSFORMATION_INDEX, (Object)index), transformation.getCacheKey());
            }
            extras.put(EXTRA_TRANSFORMATION_SIZE, options.getSize().toString());
        }
        return new MemoryCache.Key(base, extras);
    }

    @Nullable
    public final MemoryCache.Value getCacheValue(@NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull Size size2) {
        MemoryCache.Value value;
        MemoryCache.Value cacheValue;
        if (!request.getMemoryCachePolicy().getReadEnabled()) {
            return null;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        MemoryCache.Value value2 = cacheValue = memoryCache == null ? null : memoryCache.get(cacheKey);
        if (value2 == null) {
            value = null;
        } else {
            MemoryCache.Value value3;
            MemoryCache.Value it = value3 = value2;
            boolean bl = false;
            value = this.isCacheValueValid$coil_base_release(request, cacheKey, it, size2) ? value3 : null;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final boolean isCacheValueValid$coil_base_release(@NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull MemoryCache.Value cacheValue, @NotNull Size size2) {
        if (!this.requestService.isConfigValidForHardware(request, -Bitmaps.getSafeConfig(cacheValue.getBitmap()))) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 3;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var11_10 = tag$iv;
                    void var10_11 = $this$log$iv;
                    boolean bl = false;
                    String string2 = request.getData() + ": Cached bitmap is hardware-backed, which is incompatible with the request.";
                    var10_11.log((String)var11_10, n, string2, null);
                }
            }
            return false;
        }
        return this.isSizeValid(request, cacheKey, cacheValue, size2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeValid(ImageRequest request, MemoryCache.Key cacheKey, MemoryCache.Value cacheValue, Size size2) {
        double downsampleMultiplier;
        boolean isSampled = this.isSampled(cacheValue);
        if (-Sizes.isOriginal(size2)) {
            if (isSampled) {
                Logger logger = this.logger;
                if (logger != null) {
                    void $this$log$iv;
                    Logger logger2 = logger;
                    String string = TAG;
                    int priority$iv = 3;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        void tag$iv;
                        int n = priority$iv;
                        void var21_17 = tag$iv;
                        void var20_20 = $this$log$iv;
                        boolean bl = false;
                        String string2 = request.getData() + ": Requested original size, but cached image is sampled.";
                        var20_20.log((String)var21_17, n, string2, null);
                    }
                }
                return false;
            }
            return true;
        }
        String transformationSize = cacheKey.getExtras().get(EXTRA_TRANSFORMATION_SIZE);
        if (transformationSize != null) {
            return Intrinsics.areEqual((Object)transformationSize, (Object)size2.toString());
        }
        int srcWidth = cacheValue.getBitmap().getWidth();
        int srcHeight = cacheValue.getBitmap().getHeight();
        int dstWidth = this.pxOrMinMax(size2.getWidth(), request.getScale());
        int dstHeight = this.pxOrMinMax(size2.getHeight(), request.getScale());
        double multiplier = DecodeUtils.computeSizeMultiplier(srcWidth, srcHeight, dstWidth, dstHeight, request.getScale());
        boolean allowInexactSize = -Requests.getAllowInexactSize(request);
        if (allowInexactSize ? Math.abs((double)dstWidth - (downsampleMultiplier = RangesKt.coerceAtMost((double)multiplier, (double)1.0)) * (double)srcWidth) <= 1.0 || Math.abs((double)dstHeight - downsampleMultiplier * (double)srcHeight) <= 1.0 : !(!-Utils.isMinOrMax(dstWidth) && Math.abs(dstWidth - srcWidth) > 1 || !-Utils.isMinOrMax(dstHeight) && Math.abs(dstHeight - srcHeight) > 1)) {
            return true;
        }
        if (!(multiplier == 1.0) && !allowInexactSize) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger3 = logger;
                String string = TAG;
                int priority$iv = 3;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var21_18 = tag$iv;
                    void var20_21 = $this$log$iv;
                    boolean bl = false;
                    String string3 = request.getData() + ": Cached image's request size (" + srcWidth + ", " + srcHeight + ") does not exactly match the requested size (" + -Utils.pxString(size2.getWidth()) + ", " + -Utils.pxString(size2.getHeight()) + ", " + (Object)((Object)request.getScale()) + ").";
                    var20_21.log((String)var21_18, n, string3, null);
                }
            }
            return false;
        }
        if (multiplier > 1.0 && isSampled) {
            Logger logger = this.logger;
            if (logger != null) {
                Logger $this$log$iv = logger;
                String tag$iv = TAG;
                int priority$iv = 3;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    int n = priority$iv;
                    String string = tag$iv;
                    Logger logger4 = $this$log$iv;
                    boolean bl = false;
                    String string4 = request.getData() + ": Cached image's request size (" + srcWidth + ", " + srcHeight + ") is smaller than the requested size (" + -Utils.pxString(size2.getWidth()) + ", " + -Utils.pxString(size2.getHeight()) + ", " + (Object)((Object)request.getScale()) + ").";
                    logger4.log(string, n, string4, null);
                }
            }
            return false;
        }
        return true;
    }

    public final boolean setCacheValue(@Nullable MemoryCache.Key cacheKey, @NotNull ImageRequest request, @NotNull EngineInterceptor.ExecuteResult result2) {
        if (!request.getMemoryCachePolicy().getWriteEnabled()) {
            return false;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        if (memoryCache == null || cacheKey == null) {
            return false;
        }
        Drawable drawable = result2.getDrawable();
        BitmapDrawable bitmapDrawable = drawable instanceof BitmapDrawable ? (BitmapDrawable)drawable : null;
        Object object = bitmapDrawable == null ? null : bitmapDrawable.getBitmap();
        if (object == null) {
            return false;
        }
        Bitmap bitmap = object;
        Map extras = new LinkedHashMap();
        extras.put(EXTRA_IS_SAMPLED, result2.isSampled());
        String string = result2.getDiskCacheKey();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Map map = extras;
            String string2 = EXTRA_DISK_CACHE_KEY;
            map.put(string2, it);
        }
        memoryCache.set(cacheKey, new MemoryCache.Value(bitmap, extras));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SuccessResult newResult(@NotNull Interceptor.Chain chain, @NotNull ImageRequest request, @NotNull MemoryCache.Key cacheKey, @NotNull MemoryCache.Value cacheValue) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        Bitmap bitmap = cacheValue.getBitmap();
        Context context$iv = request.getContext();
        boolean $i$f$toDrawable = false;
        void var8_8 = $this$toDrawable$iv;
        Resources resources$iv$iv = context$iv.getResources();
        boolean $i$f$toDrawable2 = false;
        return new SuccessResult((Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv), request, DataSource.MEMORY_CACHE, cacheKey, this.getDiskCacheKey(cacheValue), this.isSampled(cacheValue), -Utils.isPlaceholderCached(chain));
    }

    private final int pxOrMinMax(Dimension $this$pxOrMinMax, Scale scale) {
        int n;
        Dimension $this$pxOrElse$iv = $this$pxOrMinMax;
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
                case 1: {
                    n = Integer.MAX_VALUE;
                    break;
                }
                case 2: {
                    n = Integer.MIN_VALUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return n;
    }

    private final boolean isSampled(MemoryCache.Value $this$isSampled) {
        Object object = $this$isSampled.getExtras().get(EXTRA_IS_SAMPLED);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl == null ? false : bl;
    }

    private final String getDiskCacheKey(MemoryCache.Value $this$diskCacheKey) {
        Object object = $this$diskCacheKey.getExtras().get(EXTRA_DISK_CACHE_KEY);
        return object instanceof String ? (String)object : null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcoil/memory/MemoryCacheService$Companion;", "", "()V", "EXTRA_DISK_CACHE_KEY", "", "getEXTRA_DISK_CACHE_KEY$coil_base_release$annotations", "EXTRA_IS_SAMPLED", "getEXTRA_IS_SAMPLED$coil_base_release$annotations", "EXTRA_TRANSFORMATION_INDEX", "getEXTRA_TRANSFORMATION_INDEX$coil_base_release$annotations", "EXTRA_TRANSFORMATION_SIZE", "getEXTRA_TRANSFORMATION_SIZE$coil_base_release$annotations", "TAG", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getEXTRA_TRANSFORMATION_INDEX$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getEXTRA_TRANSFORMATION_SIZE$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getEXTRA_IS_SAMPLED$coil_base_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getEXTRA_DISK_CACHE_KEY$coil_base_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            nArray[Scale.FIT.ordinal()] = 1;
            nArray[Scale.FILL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

