/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import coil.decode.ImageSource;
import coil.util.-Utils;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/decode/SourceImageSource;", "Lcoil/decode/ImageSource;", "source", "Lokio/BufferedSource;", "cacheDirectory", "Ljava/io/File;", "metadata", "Lcoil/decode/ImageSource$Metadata;", "(Lokio/BufferedSource;Ljava/io/File;Lcoil/decode/ImageSource$Metadata;)V", "file", "isClosed", "", "getMetadata", "()Lcoil/decode/ImageSource$Metadata;", "assertNotClosed", "", "close", "fileOrNull", "sourceOrNull", "coil-base_release"})
public final class SourceImageSource
extends ImageSource {
    @NotNull
    private final File cacheDirectory;
    @Nullable
    private final ImageSource.Metadata metadata;
    private boolean isClosed;
    @Nullable
    private BufferedSource source;
    @Nullable
    private File file;

    public SourceImageSource(@NotNull BufferedSource source, @NotNull File cacheDirectory, @Nullable ImageSource.Metadata metadata) {
        super(null);
        this.cacheDirectory = cacheDirectory;
        this.metadata = metadata;
        this.source = source;
        if (!this.cacheDirectory.isDirectory()) {
            boolean bl = false;
            String string = "cacheDirectory must be a directory.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public ImageSource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public synchronized BufferedSource source() {
        BufferedSource bufferedSource;
        this.assertNotClosed();
        BufferedSource bufferedSource2 = this.source;
        if (bufferedSource2 != null) {
            BufferedSource it = bufferedSource2;
            boolean bl = false;
            return it;
        }
        File file = this.file;
        Intrinsics.checkNotNull((Object)file);
        BufferedSource it = bufferedSource = Okio.buffer((Source)Okio.source((File)file));
        boolean bl = false;
        this.source = it;
        return bufferedSource;
    }

    @Override
    @NotNull
    public BufferedSource sourceOrNull() {
        return this.source();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public synchronized File file() {
        this.assertNotClosed();
        File file = this.file;
        if (file != null) {
            File it = file;
            boolean bl = false;
            return it;
        }
        File tempFile = File.createTempFile("tmp", null, this.cacheDirectory);
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        Object object = (Closeable)bufferedSource;
        Object it = null;
        try {
            long l;
            BufferedSource it22 = (BufferedSource)object;
            boolean bl = false;
            Closeable closeable = (Closeable)Okio.sink$default((File)tempFile, (boolean)false, (int)1, null);
            Throwable throwable = null;
            try {
                Sink p0 = (Sink)closeable;
                boolean bl2 = false;
                l = it22.readAll(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            long it22 = l;
        }
        catch (Throwable it22) {
            it = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)it);
        }
        this.source = null;
        it = object = tempFile;
        boolean bl = false;
        this.file = it;
        return object;
    }

    @Override
    @Nullable
    public synchronized File fileOrNull() {
        this.assertNotClosed();
        return this.file;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        BufferedSource bufferedSource = this.source;
        if (bufferedSource != null) {
            -Utils.closeQuietly((Closeable)bufferedSource);
        }
        File file = this.file;
        if (file != null) {
            file.delete();
        }
    }

    private final void assertNotClosed() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
    }
}

