/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-Bitmaps;
import coil.util.-Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/util/DrawableUtils;", "", "()V", "DEFAULT_SIZE", "", "convertToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "config", "Landroid/graphics/Bitmap$Config;", "size", "Lcoil/size/Size;", "scale", "Lcoil/size/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "coil-base_release"})
public final class DrawableUtils {
    @NotNull
    public static final DrawableUtils INSTANCE = new DrawableUtils();
    private static final int DEFAULT_SIZE = 512;

    private DrawableUtils() {
    }

    @WorkerThread
    @NotNull
    public final Bitmap convertToBitmap(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Size size2, @NotNull Scale scale, boolean allowInexactSize) {
        Rect rect;
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable && this.isConfigValid(bitmap = ((BitmapDrawable)drawable).getBitmap(), config) && this.isSizeValid(allowInexactSize, size2, bitmap, scale)) {
            return bitmap;
        }
        Drawable safeDrawable = drawable.mutate();
        int n = -Utils.getWidth(safeDrawable);
        int n2 = 0;
        boolean bl = false;
        int it = n;
        boolean bl2 = false;
        int srcWidth = it > 0 ? it : 512;
        n2 = -Utils.getHeight(safeDrawable);
        bl = false;
        it = 0;
        int it2 = n2;
        boolean bl3 = false;
        int srcHeight = it2 > 0 ? it2 : 512;
        PixelSize pixelSize = DecodeUtils.computePixelSize(srcWidth, srcHeight, size2, scale);
        int width = pixelSize.component1();
        int height = pixelSize.component2();
        Bitmap.Config config$iv = -Bitmaps.toSoftware(config);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config$iv);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
        Bitmap bitmap3 = bitmap2;
        Drawable drawable2 = safeDrawable;
        boolean bl4 = false;
        boolean bl5 = false;
        Drawable $this$convertToBitmap_u24lambda_u2d2 = drawable2;
        boolean bl6 = false;
        Rect $this$component1$iv = rect = safeDrawable.getBounds();
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$convertToBitmap_u24lambda_u2d2.setBounds(0, 0, width, height);
        $this$convertToBitmap_u24lambda_u2d2.draw(new Canvas(bitmap3));
        $this$convertToBitmap_u24lambda_u2d2.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap3;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == -Bitmaps.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Size size2, Bitmap bitmap, Scale scale) {
        return allowInexactSize || size2 instanceof OriginalSize || Intrinsics.areEqual((Object)size2, (Object)DecodeUtils.computePixelSize(bitmap.getWidth(), bitmap.getHeight(), size2, scale));
    }
}

