/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.Px;
import coil.decode.DecodeUtils;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import coil.transform.Transformation;
import coil.util.-Bitmaps;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcoil/transform/RoundedCornersTransformation;", "Lcoil/transform/Transformation;", "radius", "", "(F)V", "topLeft", "topRight", "bottomLeft", "bottomRight", "(FFFF)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "transform", "Landroid/graphics/Bitmap;", "input", "size", "Lcoil/size/Size;", "(Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coil-base_release"})
public final class RoundedCornersTransformation
implements Transformation {
    private final float topLeft;
    private final float topRight;
    private final float bottomLeft;
    private final float bottomRight;
    @NotNull
    private final String cacheKey;

    public RoundedCornersTransformation(@Px float topLeft, @Px float topRight, @Px float bottomLeft, @Px float bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        boolean bl = this.topLeft >= 0.0f && this.topRight >= 0.0f && this.bottomLeft >= 0.0f && this.bottomRight >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "All radii must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.cacheKey = this.getClass().getName() + '-' + this.topLeft + ',' + this.topRight + ',' + this.bottomLeft + ',' + this.bottomRight;
    }

    public /* synthetic */ RoundedCornersTransformation(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        this(f, f2, f3, f4);
    }

    public RoundedCornersTransformation(@Px float radius) {
        this(radius, radius, radius, radius);
    }

    @Override
    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size2, @NotNull Continuation<? super Bitmap> $completion) {
        Canvas c$iv;
        Bitmap output;
        Paint paint = new Paint(3);
        int outputWidth = 0;
        int outputHeight = 0;
        Size size3 = size2;
        if (size3 instanceof PixelSize) {
            double multiplier = DecodeUtils.computeSizeMultiplier(input.getWidth(), input.getHeight(), ((PixelSize)size2).getWidth(), ((PixelSize)size2).getHeight(), Scale.FILL);
            outputWidth = MathKt.roundToInt((double)((double)((PixelSize)size2).getWidth() / multiplier));
            outputHeight = MathKt.roundToInt((double)((double)((PixelSize)size2).getHeight() / multiplier));
        } else if (size3 instanceof OriginalSize) {
            outputWidth = input.getWidth();
            outputHeight = input.getHeight();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Bitmap.Config config$iv = -Bitmaps.getSafeConfig(input);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)outputWidth, (int)outputHeight, (Bitmap.Config)config$iv);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
        Bitmap $this$applyCanvas$iv = output = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$transform_u24lambda_u2d2 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$transform_u24lambda_u2d2.drawColor(0, PorterDuff.Mode.CLEAR);
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(outputWidth - input.getWidth()) / 2.0f, (float)(outputHeight - input.getHeight()) / 2.0f);
        BitmapShader shader = new BitmapShader(input, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        shader.setLocalMatrix(matrix);
        paint.setShader((Shader)shader);
        float[] fArray = new float[]{this.topLeft, this.topLeft, this.topRight, this.topRight, this.bottomRight, this.bottomRight, this.bottomLeft, this.bottomLeft};
        float[] radii = fArray;
        RectF rect = new RectF(0.0f, 0.0f, (float)$this$transform_u24lambda_u2d2.getWidth(), (float)$this$transform_u24lambda_u2d2.getHeight());
        Path path = new Path();
        boolean bl2 = false;
        boolean bl3 = false;
        Path $this$transform_u24lambda_u2d2_u24lambda_u2d1 = path;
        boolean bl4 = false;
        $this$transform_u24lambda_u2d2_u24lambda_u2d1.addRoundRect(rect, radii, Path.Direction.CW);
        Path path2 = path;
        $this$transform_u24lambda_u2d2.drawPath(path2, paint);
        return output;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RoundedCornersTransformation && this.topLeft == ((RoundedCornersTransformation)other).topLeft && this.topRight == ((RoundedCornersTransformation)other).topRight && this.bottomLeft == ((RoundedCornersTransformation)other).bottomLeft && this.bottomRight == ((RoundedCornersTransformation)other).bottomRight;
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.topLeft);
        result2 = 31 * result2 + Float.hashCode(this.topRight);
        result2 = 31 * result2 + Float.hashCode(this.bottomLeft);
        result2 = 31 * result2 + Float.hashCode(this.bottomRight);
        return result2;
    }

    public RoundedCornersTransformation() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

