/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.exifinterface.media.ExifInterface;
import coil.ImageLoader;
import coil.decode.BitmapFactoryDecoder;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.ImageSource;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.size.PixelSize;
import coil.size.Size;
import coil.util.-Bitmaps;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0011\u0010\u0014\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010\u001a\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcoil/decode/BitmapFactoryDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Lkotlinx/coroutines/sync/Semaphore;)V", "paint", "Landroid/graphics/Paint;", "applyExifTransformations", "Landroid/graphics/Bitmap;", "inBitmap", "config", "Landroid/graphics/Bitmap$Config;", "isFlipped", "", "rotationDegrees", "", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldReadExifData", "mimeType", "", "computeConfig", "Landroid/graphics/BitmapFactory$Options;", "Companion", "ExceptionCatchingSource", "ExifInterfaceInputStream", "Factory", "coil-base_release"})
public final class BitmapFactoryDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    @NotNull
    private final Semaphore parallelismLock;
    @NotNull
    private final Paint paint;
    @NotNull
    private static final String MIME_TYPE_JPEG = "image/jpeg";
    @NotNull
    private static final String MIME_TYPE_WEBP = "image/webp";
    @NotNull
    private static final String MIME_TYPE_HEIC = "image/heic";
    @NotNull
    private static final String MIME_TYPE_HEIF = "image/heif";
    private static final int GIGABYTE_IN_BYTES = 0x40000000;
    public static final int DEFAULT_MAX_PARALLELISM = 4;
    @NotNull
    private static final String[] SUPPORTED_EXIF_MIME_TYPES;

    @JvmOverloads
    public BitmapFactoryDecoder(@NotNull ImageSource source, @NotNull Options options, @NotNull Semaphore parallelismLock) {
        this.source = source;
        this.options = options;
        this.parallelismLock = parallelismLock;
        this.paint = new Paint(3);
    }

    public /* synthetic */ BitmapFactoryDecoder(ImageSource imageSource, Options options, Semaphore semaphore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            semaphore = SemaphoreKt.Semaphore$default((int)Integer.MAX_VALUE, (int)0, (int)2, null);
        }
        this(imageSource, options, semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> var1_1) {
        if (!(var1_1 instanceof decode.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BitmapFactoryDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.decode((Continuation<? super DecodeResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.parallelismLock;
                $i$f$withPermit = false;
                var4_9 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withPermit$iv;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$f$withPermit = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$1;
                this = (BitmapFactoryDecoder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 3 sources

                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $continuation.L$0 = $this$withPermit$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible$default(null, (Function0)((Function0)new Function0<DecodeResult>(this){
                    final /* synthetic */ BitmapFactoryDecoder this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final DecodeResult invoke() {
                        return BitmapFactoryDecoder.access$decode(this.this$0, new BitmapFactory.Options());
                    }
                }), (Continuation)$continuation, (int)1, null);
                ** if (v1 != var8_4) goto lbl37
lbl36:
                // 1 sources

                return var8_4;
lbl37:
                // 1 sources

                ** GOTO lbl46
            }
            case 2: {
                $i$f$withPermit = false;
                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl46:
                    // 2 sources

                    var4_10 = (DecodeResult)v1;
                }
                catch (Throwable var4_11) {
                    throw var4_11;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                return var4_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DecodeResult decode(BitmapFactory.Options $this$decode) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        Bitmap bitmap;
        int height2;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource((Source)this.source.source());
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$decode.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$decode);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception exception2 = exception;
            boolean bl = false;
            boolean bl2 = false;
            Exception it = exception2;
            boolean bl3 = false;
            throw it;
        }
        $this$decode.inJustDecodeBounds = false;
        boolean isFlipped = false;
        int rotationDegrees = 0;
        if (this.shouldReadExifData($this$decode.outMimeType)) {
            InputStream inputStream = safeBufferedSource.peek().inputStream();
            ExifInterface exifInterface = new ExifInterface((InputStream)new ExifInterfaceInputStream(inputStream));
            Exception it = safeSource.getException();
            if (it != null) {
                Exception bl3 = it;
                boolean bl = false;
                boolean bl4 = false;
                Exception it2 = bl3;
                boolean bl5 = false;
                throw it2;
            }
            isFlipped = exifInterface.isFlipped();
            rotationDegrees = exifInterface.getRotationDegrees();
        } else {
            isFlipped = false;
            rotationDegrees = 0;
        }
        boolean isSwapped = rotationDegrees == 90 || rotationDegrees == 270;
        int srcWidth = isSwapped ? $this$decode.outHeight : $this$decode.outWidth;
        int srcHeight = isSwapped ? $this$decode.outWidth : $this$decode.outHeight;
        $this$decode.inPreferredConfig = this.computeConfig($this$decode, this.options, isFlipped, rotationDegrees);
        $this$decode.inPremultiplied = this.options.getPremultipliedAlpha();
        if (Build.VERSION.SDK_INT >= 26 && this.options.getColorSpace() != null) {
            $this$decode.inPreferredColorSpace = this.options.getColorSpace();
        }
        $this$decode.inMutable = false;
        $this$decode.inScaled = false;
        if ($this$decode.outWidth <= 0 || $this$decode.outHeight <= 0) {
            $this$decode.inSampleSize = 1;
            $this$decode.inScaled = false;
            $this$decode.inBitmap = null;
        } else if (!(this.options.getSize() instanceof PixelSize)) {
            $this$decode.inSampleSize = 1;
            $this$decode.inScaled = false;
        } else {
            Size bl3 = this.options.getSize();
            int width22 = ((PixelSize)bl3).component1();
            height2 = ((PixelSize)bl3).component2();
            $this$decode.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, width22, height2, this.options.getScale());
            double rawScale222 = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$decode.inSampleSize, (double)srcHeight / (double)$this$decode.inSampleSize, (double)width22, (double)height2, this.options.getScale());
            double scale = this.options.getAllowInexactSize() ? RangesKt.coerceAtMost((double)rawScale222, (double)1.0) : rawScale222;
            boolean bl = $this$decode.inScaled = !(scale == 1.0);
            if ($this$decode.inScaled) {
                if (scale > 1.0) {
                    $this$decode.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale));
                    $this$decode.inTargetDensity = Integer.MAX_VALUE;
                } else {
                    $this$decode.inDensity = Integer.MAX_VALUE;
                    $this$decode.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale));
                }
            }
        }
        Object width22 = (Closeable)safeBufferedSource;
        height2 = 0;
        boolean rawScale222 = false;
        Throwable rawScale222 = null;
        try {
            BufferedSource it = (BufferedSource)width22;
            boolean bl = false;
            it = BitmapFactory.decodeStream((InputStream)it.inputStream(), null, (BitmapFactory.Options)$this$decode);
        }
        catch (Throwable it) {
            rawScale222 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)width22, (Throwable)rawScale222);
        }
        BufferedSource outBitmap = it;
        width22 = safeSource.getException();
        if (width22 != null) {
            Object height2 = width22;
            boolean rawScale222 = false;
            boolean it = false;
            Object it3 = height2;
            boolean bl = false;
            throw it3;
        }
        boolean width22 = false;
        height2 = 0;
        if (outBitmap == null) {
            boolean bl = false;
            String height2 = "BitmapFactory returned a null bitmap. Often this means BitmapFactory could not decode the image data read from the input source (e.g. network, disk, or memory) as it's not encoded as a valid image format.";
            throw (Throwable)new IllegalStateException(height2.toString());
        }
        outBitmap.setDensity(this.options.getContext().getResources().getDisplayMetrics().densityDpi);
        Bitmap height2 = bitmap = this.applyExifTransformations((Bitmap)outBitmap, $this$decode.inPreferredConfig, isFlipped, rotationDegrees);
        Context context$iv = this.options.getContext();
        boolean $i$f$toDrawable = false;
        void it3 = $this$toDrawable$iv;
        Resources resources$iv$iv = context$iv.getResources();
        boolean $i$f$toDrawable2 = false;
        return new DecodeResult((Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv), $this$decode.inSampleSize > 1 || $this$decode.inScaled);
    }

    private final boolean shouldReadExifData(String mimeType) {
        return mimeType != null && ArraysKt.contains((Object[])SUPPORTED_EXIF_MIME_TYPES, (Object)mimeType);
    }

    private final Bitmap.Config computeConfig(BitmapFactory.Options $this$computeConfig, Options options, boolean isFlipped, int rotationDegrees) {
        Bitmap.Config config = options.getConfig();
        if (isFlipped || rotationDegrees > 0) {
            config = -Bitmaps.toSoftware(config);
        }
        if (options.getAllowRgb565() && config == Bitmap.Config.ARGB_8888 && Intrinsics.areEqual((Object)$this$computeConfig.outMimeType, (Object)MIME_TYPE_JPEG)) {
            config = Bitmap.Config.RGB_565;
        }
        if (Build.VERSION.SDK_INT >= 26 && $this$computeConfig.outConfig == Bitmap.Config.RGBA_F16 && config != Bitmap.Config.HARDWARE) {
            config = Bitmap.Config.RGBA_F16;
        }
        return config;
    }

    private final Bitmap applyExifTransformations(Bitmap inBitmap, Bitmap.Config config, boolean isFlipped, int rotationDegrees) {
        Canvas c$iv;
        Bitmap outBitmap;
        Bitmap bitmap;
        boolean isRotated;
        boolean bl = isRotated = rotationDegrees > 0;
        if (!isFlipped && !isRotated) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (isFlipped) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (isRotated) {
            matrix.postRotate((float)rotationDegrees, centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (!(rect.left == 0.0f) || !(rect.top == 0.0f)) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        switch (rotationDegrees) {
            case 90: 
            case 270: {
                int width$iv;
                int n = inBitmap.getHeight();
                int height$iv = inBitmap.getWidth();
                boolean $i$f$createBitmap = false;
                Bitmap bitmap2 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
                bitmap = bitmap2;
                break;
            }
            default: {
                int width$iv = inBitmap.getWidth();
                int height$iv = inBitmap.getHeight();
                boolean $i$f$createBitmap = false;
                Bitmap bitmap2 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
                bitmap = bitmap2;
            }
        }
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyExifTransformations_u24lambda_u2d6 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl2 = false;
        $this$applyExifTransformations_u24lambda_u2d6.drawBitmap(inBitmap, matrix, this.paint);
        inBitmap.recycle();
        return outBitmap;
    }

    @JvmOverloads
    public BitmapFactoryDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, null, 4, null);
    }

    public static final /* synthetic */ DecodeResult access$decode(BitmapFactoryDecoder $this, BitmapFactory.Options $receiver) {
        return $this.decode($receiver);
    }

    static {
        String[] stringArray = new String[]{MIME_TYPE_JPEG, MIME_TYPE_WEBP, MIME_TYPE_HEIC, MIME_TYPE_HEIF};
        SUPPORTED_EXIF_MIME_TYPES = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "maxParallelism", "", "(I)V", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "equals", "", "other", "", "hashCode", "coil-base_release"})
    public static final class Factory
    implements Decoder.Factory {
        @NotNull
        private final Semaphore parallelismLock;

        @JvmOverloads
        public Factory(int maxParallelism) {
            this.parallelismLock = SemaphoreKt.Semaphore$default((int)maxParallelism, (int)0, (int)2, null);
        }

        public /* synthetic */ Factory(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4;
            }
            this(n);
        }

        @Override
        @NotNull
        public Decoder create(@NotNull SourceResult result2, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            return new BitmapFactoryDecoder(result2.getSource(), options, this.parallelismLock);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Factory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @JvmOverloads
        public Factory() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R.\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "coil-base_release"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        public ExceptionCatchingSource(@NotNull Source delegate) {
            super(delegate);
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExifInterfaceInputStream;", "Ljava/io/InputStream;", "delegate", "(Ljava/io/InputStream;)V", "availableBytes", "", "available", "close", "", "interceptBytesRead", "bytesRead", "read", "b", "", "off", "len", "skip", "", "n", "coil-base_release"})
    private static final class ExifInterfaceInputStream
    extends InputStream {
        @NotNull
        private final InputStream delegate;
        private int availableBytes;

        public ExifInterfaceInputStream(@NotNull InputStream delegate) {
            this.delegate = delegate;
            this.availableBytes = 0x40000000;
        }

        @Override
        public int read() {
            return this.interceptBytesRead(this.delegate.read());
        }

        @Override
        public int read(@NotNull byte[] b) {
            return this.interceptBytesRead(this.delegate.read(b));
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            return this.interceptBytesRead(this.delegate.read(b, off, len));
        }

        @Override
        public long skip(long n) {
            return this.delegate.skip(n);
        }

        @Override
        public int available() {
            return this.availableBytes;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        private final int interceptBytesRead(int bytesRead) {
            if (bytesRead == -1) {
                this.availableBytes = 0;
            }
            return bytesRead;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Companion;", "", "()V", "DEFAULT_MAX_PARALLELISM", "", "GIGABYTE_IN_BYTES", "MIME_TYPE_HEIC", "", "MIME_TYPE_HEIF", "MIME_TYPE_JPEG", "MIME_TYPE_WEBP", "SUPPORTED_EXIF_MIME_TYPES", "", "[Ljava/lang/String;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

