/*
 * Decompiled with CFR 0.152.
 */
package coil.network;

import coil.util.Option;
import kotlin.Metadata;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\fJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006 "}, d2={"Lcoil/network/CacheResponse;", "", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "isTls", "", "()Z", "lazyCacheControl", "Lokhttp3/CacheControl;", "lazyContentType", "Lcoil/util/Option;", "Lokhttp3/MediaType;", "receivedResponseAtMillis", "", "getReceivedResponseAtMillis", "()J", "responseHeaders", "Lokhttp3/Headers;", "getResponseHeaders", "()Lokhttp3/Headers;", "sentRequestAtMillis", "getSentRequestAtMillis", "cacheControl", "contentType", "writeTo", "", "sink", "Lokio/BufferedSink;", "coil-base_release"})
public final class CacheResponse {
    @Nullable
    private CacheControl lazyCacheControl;
    @Nullable
    private Option<MediaType> lazyContentType;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final boolean isTls;
    @NotNull
    private final Headers responseHeaders;

    public final long getSentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long getReceivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public final boolean isTls() {
        return this.isTls;
    }

    @NotNull
    public final Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    public CacheResponse(@NotNull BufferedSource source) {
        String string = source.readUtf8LineStrict();
        boolean bl = false;
        this.sentRequestAtMillis = Long.parseLong(string);
        string = source.readUtf8LineStrict();
        bl = false;
        this.receivedResponseAtMillis = Long.parseLong(string);
        string = source.readUtf8LineStrict();
        bl = false;
        this.isTls = Integer.parseInt(string) > 0;
        String string2 = source.readUtf8LineStrict();
        int n = 0;
        int responseHeadersLineCount = Integer.parseInt(string2);
        Headers.Builder responseHeaders = new Headers.Builder();
        n = 0;
        if (n < responseHeadersLineCount) {
            do {
                int i = n++;
                responseHeaders.add(source.readUtf8LineStrict());
            } while (n < responseHeadersLineCount);
        }
        this.responseHeaders = responseHeaders.build();
    }

    public CacheResponse(@NotNull Response response) {
        this.sentRequestAtMillis = response.sentRequestAtMillis();
        this.receivedResponseAtMillis = response.receivedResponseAtMillis();
        this.isTls = response.handshake() != null;
        this.responseHeaders = response.headers();
    }

    public final void writeTo(@NotNull BufferedSink sink) {
        int n = 10;
        int n2 = 0;
        sink.writeDecimalLong(this.sentRequestAtMillis).writeByte(n);
        n = 10;
        n2 = 0;
        sink.writeDecimalLong(this.receivedResponseAtMillis).writeByte(n);
        n = 10;
        n2 = 0;
        sink.writeDecimalLong(this.isTls ? 1L : 0L).writeByte(n);
        n = 10;
        n2 = 0;
        sink.writeDecimalLong((long)this.responseHeaders.size()).writeByte(n);
        n = 0;
        n2 = this.responseHeaders.size();
        if (n < n2) {
            do {
                int i = n++;
                int n3 = 10;
                boolean bl = false;
                sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(n3);
            } while (n < n2);
        }
    }

    @NotNull
    public final CacheControl cacheControl() {
        CacheControl cacheControl;
        CacheControl cacheControl2 = this.lazyCacheControl;
        if (cacheControl2 == null) {
            CacheControl cacheControl3 = CacheControl.Companion.parse(this.responseHeaders);
            boolean bl = false;
            boolean bl2 = false;
            CacheControl it = cacheControl3;
            boolean bl3 = false;
            this.lazyCacheControl = it;
            cacheControl = cacheControl3;
        } else {
            cacheControl = cacheControl2;
        }
        return cacheControl;
    }

    @Nullable
    public final MediaType contentType() {
        Object object;
        Option<MediaType> option = this.lazyContentType;
        if (option == null) {
            Object object2 = this.responseHeaders.get("Content-Type");
            object2 = new Option<Object>((object2 == null ? null : MediaType.Companion.parse((String)object2)));
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.lazyContentType = it;
            object = object2;
        } else {
            object = option;
        }
        return (MediaType)((Option)object).value;
    }
}

