/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.systemtests;

import com.google.common.collect.Sets;
import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.entities.CompilationArtifact;
import io.cloudslang.lang.entities.SystemProperty;
import io.cloudslang.lang.entities.bindings.values.Value;
import io.cloudslang.lang.runtime.events.LanguageEventData;
import io.cloudslang.lang.systemtests.BranchAggregatorListener;
import io.cloudslang.lang.systemtests.JoinAggregatorListener;
import io.cloudslang.lang.systemtests.RunDataAggregatorListener;
import io.cloudslang.lang.systemtests.RuntimeInformation;
import io.cloudslang.lang.systemtests.StepData;
import io.cloudslang.score.events.ScoreEvent;
import io.cloudslang.score.events.ScoreEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;

public class TriggerFlows {
    private static final HashSet<String> FINISHED_EVENTS = Sets.newHashSet((Object[])new String[]{"EVENT_EXECUTION_FINISHED", "SLANG_EXECUTION_EXCEPTION"});
    private static final HashSet<String> STEP_EVENTS = Sets.newHashSet((Object[])new String[]{"EVENT_INPUT_END", "EVENT_OUTPUT_END", "EVENT_ARGUMENT_START", "EVENT_ARGUMENT_END"});
    private static final HashSet<String> BRANCH_EVENTS = Sets.newHashSet((Object[])new String[]{"EVENT_BRANCH_END"});
    private static final HashSet<String> PARALLEL_LOOP_EVENTS = Sets.newHashSet((Object[])new String[]{"EVENT_JOIN_BRANCHES_END"});
    private static final HashSet<String> ALL_CLOUDSLANG_EVENTS = Sets.newHashSet((Object[])new String[]{"SLANG_EXECUTION_EXCEPTION", "EVENT_ACTION_START", "EVENT_ACTION_END", "EVENT_ACTION_ERROR", "EVENT_INPUT_START", "EVENT_INPUT_END", "EVENT_STEP_START", "EVENT_ARGUMENT_START", "EVENT_ARGUMENT_END", "EVENT_OUTPUT_START", "EVENT_OUTPUT_END", "EVENT_EXECUTION_FINISHED", "EVENT_BRANCH_START", "EVENT_BRANCH_END", "EVENT_SPLIT_BRANCHES", "EVENT_JOIN_BRANCHES_START", "EVENT_JOIN_BRANCHES_END"});
    @Autowired
    private Slang slang;

    public ScoreEvent runSync(CompilationArtifact compilationArtifact, Map<String, Value> userInputs, Set<SystemProperty> systemProperties) {
        return this.runSync(compilationArtifact, userInputs, systemProperties, true);
    }

    public ScoreEvent runSync(CompilationArtifact compilationArtifact, Map<String, Value> userInputs, Set<SystemProperty> systemProperties, boolean shouldFail) {
        final LinkedBlockingQueue finishEvent = new LinkedBlockingQueue();
        ScoreEventListener finishListener = new ScoreEventListener(){

            public synchronized void onEvent(ScoreEvent event) throws InterruptedException {
                finishEvent.add(event);
            }
        };
        this.slang.subscribeOnEvents(finishListener, FINISHED_EVENTS);
        long executionId = this.slang.run(compilationArtifact, userInputs, systemProperties);
        try {
            ScoreEvent event = null;
            boolean finishEventReceived = false;
            while (!finishEventReceived) {
                event = (ScoreEvent)finishEvent.take();
                long executionIdFromEvent = (Long)((Map)((Object)event.getData())).get("EXECUTION_ID");
                finishEventReceived = executionId == executionIdFromEvent;
            }
            if (event.getEventType().equals("SLANG_EXECUTION_EXCEPTION") && shouldFail) {
                LanguageEventData languageEvent = (LanguageEventData)event.getData();
                throw new RuntimeException(languageEvent.getException());
            }
            this.slang.unSubscribeOnEvents(finishListener);
            return event;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeInformation runWithData(CompilationArtifact compilationArtifact, Map<String, Value> userInputs, Set<SystemProperty> systemProperties) {
        RunDataAggregatorListener runDataAggregatorListener = new RunDataAggregatorListener();
        this.slang.subscribeOnEvents((ScoreEventListener)runDataAggregatorListener, STEP_EVENTS);
        BranchAggregatorListener branchAggregatorListener = new BranchAggregatorListener();
        this.slang.subscribeOnEvents((ScoreEventListener)branchAggregatorListener, BRANCH_EVENTS);
        JoinAggregatorListener joinAggregatorListener = new JoinAggregatorListener();
        this.slang.subscribeOnEvents((ScoreEventListener)joinAggregatorListener, PARALLEL_LOOP_EVENTS);
        this.runSync(compilationArtifact, userInputs, systemProperties);
        Map<String, StepData> steps = runDataAggregatorListener.aggregate();
        Map<String, List<StepData>> branchesByPath = branchAggregatorListener.aggregate();
        Map<String, StepData> parallelSteps = joinAggregatorListener.aggregate();
        RuntimeInformation runtimeInformation = new RuntimeInformation(steps, branchesByPath, parallelSteps);
        this.slang.unSubscribeOnEvents((ScoreEventListener)joinAggregatorListener);
        this.slang.unSubscribeOnEvents((ScoreEventListener)branchAggregatorListener);
        this.slang.unSubscribeOnEvents((ScoreEventListener)runDataAggregatorListener);
        return runtimeInformation;
    }

    public List<ScoreEvent> runAndCollectAllEvents(CompilationArtifact compilationArtifact, Map<String, Value> userInputs, Set<SystemProperty> systemProperties) {
        final List<ScoreEvent> events = Collections.synchronizedList(new ArrayList());
        ScoreEventListener allEventsListener = new ScoreEventListener(){

            public synchronized void onEvent(ScoreEvent event) throws InterruptedException {
                events.add(event);
            }
        };
        this.slang.subscribeOnEvents(allEventsListener, ALL_CLOUDSLANG_EVENTS);
        ScoreEvent finishEvent = this.runSync(compilationArtifact, userInputs, systemProperties, false);
        this.slang.unSubscribeOnEvents(allEventsListener);
        for (ScoreEvent scoreEvent : events) {
            String eventType = scoreEvent.getEventType();
            if (!"SLANG_EXECUTION_EXCEPTION".equals(eventType) && !"EVENT_EXECUTION_FINISHED".equals(eventType)) continue;
            return events;
        }
        events.add(finishEvent);
        return events;
    }
}

